
import Panel from "../views/Panel";
export default class MsgPanel extends Panel {
    private mData: IMsgData;
    private msgTxt:eui.Label;
    private okBtn:eui.Button;
    private againBtn:eui.Button;
    private iknowBtn:eui.Button;

    // private tfArr:egret.TextField[];

    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
		}
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        if(this.mData && this.mData.btnName){
            this[this.mData.btnName].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        }
    }

    removeEvents():void{
        super.removeEvents();
        this[this.mData.btnName].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{

        this.okBtn.name     = 'okBtn';
        this.againBtn.name  = 'againBtn';
        this.iknowBtn.name  = 'iknowBtn';

        if(this.mData && this.mData.msgArr){
            this.setBtn();
            this.setText();
        }else{
            console.log("this.mData和this.mData.msgArr为必传项！");
        }

        this.showAct();
    }

    private onTap(e:egret.TouchEvent):void{
        this.hidePanel();

        if(this.mData && this.mData.callBack){
            this.mData.callBack();
        }
    }

    onTouchTap():any{
        super.onTouchTap();

        if(this.mData && this.mData.closeCallBack){
            this.mData.closeCallBack();
        }
    }

    private setText():void{
            const family    = this.mData.fontFamily ? this.mData.fontFamily : 'Arial';
            const txtH      = this.mData.lineCount * this.mData.fontSize;
            const spaceH    = (this.mData.lineCount - 1) * this.mData.lineSpace;
            const tH        = this.mData.lineCount = 1 ? txtH : txtH + spaceH;
            const orgY      = 160;
            const maxH      = 330;
            const tY        = orgY + (maxH - tH) * 0.5;


            this.msgTxt.y           = tY;
            this.msgTxt.fontFamily  = family;
            this.msgTxt.lineSpacing = this.mData.lineSpace;
            this.msgTxt.size        = this.mData.fontSize;
            this.msgTxt.textFlow    = this.mData.msgArr; 
    }

    private setBtn():void{
        this['okBtn'].visible       = false;
        this['againBtn'].visible    = false;
        this['iknowBtn'].visible    = false;

        this[this.mData.btnName].visible = true;
    }

}

export interface IMsgData{
    btnName:string,
    lineCount:number,
    fontSize:number,
    lineSpace:number,
    fontFamily?:string,
    callBack?:Function,
    closeCallBack?:Function,
    msgArr:Array<egret.ITextElement>
}