import { ExmlPlugin } from "built-in";
import { ExmlPlugin2 } from "./ExmlPlugin2";

/**
 * 示例自定义插件，您可以查阅 http://developer.egret.com/cn/github/egret-docs/Engine2D/projectConfig/cmdExtensionPlugin/index.html
 * 了解如何开发一个自定义插件
 */
export class MyExmlPlugin extends ExmlPlugin2 implements plugins.Command {
    async onFile(file: plugins.File) {
        const excludes = [
            'bDolphin0.png',
            'bDolphin1.png',
            'bDolphin2.png',
            'mDolphin0.png',
            'mDolphin1.png',
            'mDolphin2.png',
            'sDolphin0.png',
            'sDolphin1.png',
            'sDolphin2.png',
            'haicao.png'
        ];
        if (excludes.indexOf(file.basename) != -1) {
            return file;
        }

        return super['onFile'](file);
    }
}