import getIsIOS from "../../new_tc/getIsIOS";
import doStart from "../../new_tw/ctrls/doStart";
import getCountTxt from "../../new_tw/datas/getCountTxt";
import getStartBtnEnable from "../../new_tw/datas/getStartBtnEnable";
import { DataManager } from "../../tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";
import doJoin from "../../new_tw/ctrls/doJoin";
import getJoinCountTxt from "../../new_tw/datas/getJoinCountTxt";
import wait from "../../new_tc/wait";
import { TwFun } from "../../tw/util/TwFun";

export default class StartSceneBase extends Scene {
    ruleBtn: eui.Button;
    htmlRuleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    joinBtn: eui.Button;
    rankBtn: eui.Button;

    countTxt: eui.Label;
    exemptionTxt: eui.Label;
    _timer: egret.Timer;

    async start(data?) {
        this.joinBtn.visible = false;
        this.updateGetInfoView();
        this.updateExemptionTxt();
        super.start();
    }

    private updateGetInfoView() {
        if (DataManager.ins.ajaxElementData) {
            this.updateJoinBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    async updateJoinBtnStatus() {
        if (this.joinBtn) {
            this.joinBtn.visible = true;
        }
    }

    updateCountTxt() {
        if (this.countTxt) {
            this.countTxt.text = getJoinCountTxt();
        }
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.joinBtn)
            this.joinBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_joinBtn, this);
        if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
        window.location.href = TwFun.getRecordUrl('00');
    }

    async onTap_joinBtn(e?: egret.Event) {
        // doJoin(async () => {
        //     this.updateCountTxt();
        // });
    }

    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}