import showCustomLog from "../../new_tw/ctrls/showCustomLog";
import { LotteryType } from "../../tw/enum/LotteryType";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import Panel from "./Panel";

export default class PrizePanel extends Panel {
    start(data) {
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        this.data = lottery;

        this.img.width = this.picBigWidth;
        this.img.height = this.picBigWidth / this.bigPicRatio;

        showCustomLog(lottery);
    }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
            }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    get picBigWidth() { return 512 };
    get bigPicRatio() { return 512 / 240 }

    get skinKey() { return 'Prize' }

    img: eui.Image;
    useBtn: eui.Button;

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}