import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";

const getHdGameOrderStatus = (callback: Function): void => {
    NetManager.ins.getHdGameOrderStatus(callback, DataManager.ins.doJoinData.orderId, () => {
        return DataManager.ins._getHdStartStatusData.result == 0;
    });
}


/**
 * 活动工具类型游戏子类型抽奖
 * @param callback
 * @param nextStep 下一步做什么，轮询结果或者前置开奖等
 */
const hdGameDoDojoin = (callback: Function, collectRuleId?: number): void => {
    if (window['uid'] == 'not_login') {
        window['requirelogin']();
        return;
    }
    NetManager.ins.doJoin((success: boolean) => {
        if (success) {
            getHdGameOrderStatus(callback);
        } else {
            callback(success);
        }
    }, collectRuleId);
}

export default hdGameDoDojoin