import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";

/**
 * 获取活动工具抽奖结果
 * @param callback 
 */
const getCustomOrderStatus = (callback: Function): void => {
    NetManager.ins.getCustomOrderStatus(callback, DataManager.ins.doJoinData.orderId, () => {
        return DataManager.ins.getCustomOrderStatusData.result == 0;
    });
}

/**
 * 抽奖
 * @param callback
 * @param nextStep 下一步做什么，轮询结果或者前置开奖等
 */
const doJoin = (callback: Function, score?: number, collectRuleId?: number): void => {
    if (window['uid'] == 'not_login') {
        window['requirelogin']();
        return;
    }
    NetManager.ins.doJoin((success: boolean) => {
        if (success) {
            getCustomOrderStatus(callback);
        } else {
            callback(success);
        }
    }, score, collectRuleId);
}

export default doJoin