import Loading from '../loading/Loading';
import Panel from "../views/Panel";
import { DataManager } from '../../libs/tw/manager/DataManager';
export default class TimeDownPanel extends Panel {
    public timedownLb:eui.Label;
    public titleLb:eui.Label;
    public costLb:eui.Label;
    public prizeLb:eui.Label;

    private pData:any;
    public get skinKey() { return 'TimeDownPanel' }
    public get groupName() { return 'timedown_panel' }

    constructor(data?) {
        super(data);
        this.pData = data;

    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();

    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }


    private onLoad(): void {
        let type1 = this.pData.type;
        let data = DataManager.ins.getData('checkAnswered');
        console.log('data1',data);
        if(data && data.data){
            this.prizeLb.text = '0';
        }else{
            this.prizeLb.text = window['getCredits'][type1];
        }
        this.titleLb.text = window['questionTitle'][type1];
        this.costLb.text = window['needCredits'][type1];
        let timenum = window['timedown'] ? window['timedown'] : 3;
        this.timedownLb.text = timenum;
        let idx = setInterval(()=>{
            timenum --;
            if(timenum == 0){
                this.pData.callback();
                this.onTouchTap();
            }else{
                this.timedownLb.text = timenum;
            }
        }, 1000);
    }
    


}
