
import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';
import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import BuriedCtrls from "../ctrls/BuriedCtrls";

import { Subject } from './Subject';
import { SubjectType } from '../enum/SubjectEnum';

import { GDispatcher } from '../../libs/tc/util/GDispatcher';

export default class StartScene extends Scene {
    
    public clearanceGroup:eui.Group;
    public ruleBtn:eui.Button;

    public startBtn:eui.Button;
  
    public timeLab:eui.Label;

    public downBg:eui.Image;
    public titileBg:eui.Image;
    public question_1:eui.Image;
    public question_2:eui.Image;
    public question_3:eui.Image;
    public question_4:eui.Image;

    private downBgTexture:egret.Texture;
    private questionTexture2:egret.Texture;
    private questionTexture3:egret.Texture;
    private questionTexture4:egret.Texture;
    private questionTexture5:egret.Texture;
    private questionBgTexture1:egret.Texture;
    private titleBgTexture:egret.Texture;

    //private userCredits:number = 0;
    private question:string = '';
    public closeBtn:eui.Button;
    public test1:eui.Label;
    public test2:eui.Label;
    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }
    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onAgainGame,this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.question_1.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.question_2.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.question_3.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.question_4.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickCloseBtn,this);
    }
    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onAgainGame,this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.question_1.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.question_2.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.question_3.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.question_4.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onStartGame,this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickCloseBtn,this);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }


    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.downBgTexture =  await RES.getResAsync('downBg_jpg');
        this.questionTexture2 = await RES.getResAsync('question_1_jpg');
        this.questionTexture3 = await RES.getResAsync('question_2_jpg');
        this.questionTexture4 = await RES.getResAsync('question_3_jpg');
        this.questionTexture5 = await RES.getResAsync('question_4_jpg');
        this.titleBgTexture = await RES.getResAsync('titleBg_jpg');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.downBg.texture = this.downBgTexture;
        this.question_1.texture = this.questionTexture2;
        this.question_2.texture = this.questionTexture3; 
        this.question_3.texture = this.questionTexture4;
        this.question_4.texture = this.questionTexture5; 
        this.titileBg.texture = this.titleBgTexture; 

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }
    private onLoad(): void {
        window['sceneIndex'] = 1;
        //GDispatcher.dispatchEvent('hashchange',null);
        this.test1.text = '测试';
        this.test2.text = '测试';
        this.test1.fontFamily = 'OPPOSans_J';
        this.test2.fontFamily = 'OPPOSans_S';
        //this.getUserCredits();
        this.initUI();
        this.handleBuried();
    }
    private handleBuried(){
        BuriedCtrls.instance.showLogBuried(1,1);
        BuriedCtrls.instance.showLogBuried(2,1);
        BuriedCtrls.instance.showLogBuried(3,1);
        BuriedCtrls.instance.showLogBuried(4,1);
        BuriedCtrls.instance.showLogBuried(5,1);

    }
    // private getUserCredits(){
    //     NetManager.ins.getProjectUserInfo((success,result) => {
    //         if(this.netError(success,result))
    //         {
    //             this.userCredits = result.data.consumerCredits;
    //             console.log('当前拥有的积分-',this.userCredits);
    //         }
    //     })
    // }
    private initUI():void{
        this.clearanceGroup.visible = false;
    }
    //规则
    private onTap_ruleBtn():void{
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL); 
        BuriedCtrls.instance.clickLogBuried(1,1);
    }

    private questiontype:string;
    private onStartGame(e:egret.TouchEvent):void{
        PanelCtrl.instance.btnDelay(e.target);
        let buttonTmp = e.target;
        this.question = buttonTmp.name;
        this.questiontype = buttonTmp.name;
        let needCredits = window['needCredits'][buttonTmp.name];
        console.log('需要的积分-',needCredits);
        this.checkAnswered(buttonTmp.name,needCredits);
        let dpm = parseInt(this.question.substr(this.question.length-1,1));
        BuriedCtrls.instance.clickLogBuried((dpm+1),1);
    
    }
    private onAgainGame(){
        this.clearanceGroup.visible = true;
        console.log('无积分答题');
        window['ticketNum'] = '';
        PanelCtrl.instance.btnDelay(this.startBtn);
        let dpm = parseInt(this.question.substr(this.question.length-1,1));
        BuriedCtrls.instance.clickLogBuried(10,dpm);

        //获取积分
        NetManager.ins.getProjectUserInfo((success,result) => {
            if(this.netError(success,result))
            {
                let needCredits = window['needCredits'][this.questiontype];
                let userCredits = result.data.consumerCredits;
                console.log('当前拥有的积分-', userCredits);
                if(userCredits >= needCredits){
                    let actionId = '';
                    let playwayId = 'join_1';
                    if(this.questiontype == 'question_1' || this.questiontype == 'question_2'){
                        actionId = 'doSubmit1';
                    }else{
                        actionId = 'doSubmit2';
                    }
                    this.creditsCost(playwayId,actionId);
                }else{
                    let dpm = parseInt(this.question.substr(this.question.length-1,1));
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:1,dpm:dpm});
                }
            }
        })

        // this.goToGameScene(true);
    }
//便于其它项目的接口  本项目暂不做处理
    private oppoTask(){
        return;
        NetManager.ins.oppoTask((success,result) => {
        },'ANSWER')
    }
    //查询是否已答题
    private checkAnswered(question,needCredits){
        NetManager.ins.checkAnswered((success,result) => {
            if (!result) {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
                return;
            }
            //原代码
            // if(!success){
            //     if(result.code == '100001'){
            //         PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'您尚未登录，请先登录～',buttonType:'login'});
            //     }else if(result.data){
            //         this.handleClearance();
            //     }else{
            //         PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
            //     }
            //     return;
            // }
            if(!success){
                if(result.code == '100001'){
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'您尚未登录，请先登录～',buttonType:'login'});
                }else {
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
                }
                return;
            }
            //原代码
            if(result.data)
            {
                this.handleClearance();
                return;
            }
            //获取积分
            NetManager.ins.getProjectUserInfo((success,result) => {
                if(this.netError(success,result))
                {
                    let userCredits = result.data.consumerCredits;
                    console.log('当前拥有的积分-', userCredits);
                    if(userCredits >= needCredits){
                        let actionId = '';
                        let playwayId = 'join_1';
                        if(question == 'question_1' || question == 'question_2'){
                            actionId = 'doSubmit1';
                        }else{
                            actionId = 'doSubmit2';
                        }
                        this.creditsCost(playwayId,actionId);
                    }else{
                        let dpm = parseInt(this.question.substr(this.question.length-1,1));
                        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:1,dpm:dpm});
                    }
                }
            })
   
        },question)
    }
    private handleClearance(){
        this.clearanceGroup.visible = true;
        if(window['isClearance'].indexOf(this.question) <= -1){
            window['isClearance'].push(this.question);
        }
        let dpm = parseInt(this.question.substr(this.question.length-1,1));
        BuriedCtrls.instance.showLogBuried(10,dpm);
    }
    //扣积分
    private creditsCost(playwayId,actionId){
        NetManager.ins.creditsCost((success,result) => {
            if (!result) {
                //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后重试～'});
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                return;
            }
            if(!success){
                let dpm = parseInt(this.question.substr(this.question.length-1,1));
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:1,dpm:dpm});
                return ;
            }
            window['ticketNum'] = result.data;
            this.queryStatus(result.data);
        },playwayId,actionId)
    }
    //<script src="//hdstatic.oppo.cn/common/js/RainbowBridge.js"></script>
    //查询扣积分状态
    private queryStatus(ticketNum){
        Loading.instace.show();
        NetManager.ins.queryStatus((success, result) => {
            if(result.data == '2'){
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                return;
            }
            if (result == 'pollingFaild' || !result) {
                console.log('轮询失败：' + result);
                //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后重试～'});
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                Loading.instace.hide();
            }else{
                if(!success){
                    //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后重试～'});
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                }else{
                    //显示倒计时
                    PanelCtrl.instance.show(ModuleTypes.TIMEDOWN_PANEL, {type:this.questiontype, callback:()=>{
                        this.goToGameScene();
                    }})
                }

                Loading.instace.hide();
            }
        }, ticketNum, () => {
            return DataManager.ins.getData('queryStatus').data == '0';
        });
    }
    private goToGameScene(){
        this.oppoTask();
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE,{question:this.question});
        
    }

    private netError(success,result){
        if (!result) {
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
            return false;
        }
        console.log('接口数据',result);
        if(!success){
            if(result.code == '100001' || result.code == '00000001'){
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'您尚未登录，请先登录～',buttonType:'login'});
            }else{
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
            }
            return false;
        }
        return true;
    }
    private onClickCloseBtn(){
        this.clearanceGroup.visible = false;
    }
}
