
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleType } from "../../libs/tc/enum/ModuleType";
import { ModuleTypes } from "../types/sceneTypes";
import SceneCtrl from "../ctrls/sceneCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class SharePanel extends Panel {

 
    private friendBtn:eui.Button;
    private weChatBtn:eui.Button;
  
    private startShare:boolean = false;
    private shareBack:boolean = false;

    private shareTimer;
    // private tfArr:egret.TextField[];

    public get skinKey() { return 'SharePanel' }
	public get groupName() { return 'share_panel'}
    
    constructor(data?){
        super(data);
    }

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
		}
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.friendBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickFriend, this);
        this.weChatBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickWeChat, this);
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.closePanel, this);
    }
    
    removeEvents():void{
        super.removeEvents();
        this.friendBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickFriend, this);
        this.weChatBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickWeChat, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.closePanel, this);
    }

    private onLoad():void{
        this.showAct();
        let random = Math.floor(Math.random()*5) ;
        if(random < (window['shareData'].length))
        {
            window['shareTitle'] = window['shareData'][random];
        }

        document.addEventListener('visibilitychange', function () {
            if (document.visibilityState === 'visible') {
                console.log('后台返回');
                this.shareTimeout();
            }
        }.bind(this));
        
    }
    private onClickWeChat(){
        console.log("微信好友分享");
        this.shareCallBack(1);
    }
    private onClickFriend(){
        console.log("微信朋友圈分享");
        this.shareCallBack(2);
    }

    private shareTimeout(){
        setTimeout(function(){
            if(this.startShare  && !this.shareBack)
            {
                this.shareBack = true;
                this.addTime();
            }
        }.bind(this),500)
    }
    private shareCallBack(type){
        let shareType = type + '';
        window['setupWebViewJavascriptBridge'](function (bridge) {
            console.log("成功进入分享"+bridge);
            this.startShare = true;
            bridge.callHandler('FunctionManagement', {
                                'type':'ArouseShare',
                                'param':{
                                        'title':window['shareTitle'],
                                        'content':'一线大牌清仓底价，叠加红包优惠更多，快快来参与吧！',
                                        'img':'https://yun.duiba.com.cn/db_games/activity/ypc_hongbaoyu/shareImg/shareImg.jpg',
                                        'link_url':'http://api.gongchangtemai.com/api/v1/duiba/login?redirect_url=https%3A%2F%2Factivity.m.duiba.com.cn%2Fprojectx%2Fpa9f8a92f%2Findex.html%3FshareCode%3D123',
                                        'shareType':shareType,}},
                                function(response) {
                                    response =  JSON.parse(response);
                                    console.log("回调成功",response);
                                    if(!this.shareBack)
                                    {
                                        this.shareBack = true;
                                        if(response.success && response.data.shareResult == 1)
                                        {
                                            console.log('分享返回成功');
                                            this.addTime();
                                        }
                                        else
                                        {
                                            console.log('分享失败');
                                            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                                        }
                                    }
                                }.bind(this));
          }.bind(this));
    }

    private addTime(){
        NetManager.ins.getInformation((success,result) => {
            if(success && result.data)
            {
                let sessionSettings = result.data.sessionSettings.split(',');
                let endTimeDay = result.data.sessionEndTime.split('-');
                let date = new Date(endTimeDay[0],endTimeDay[1],endTimeDay[2]).getTime();
                let endTime  =  date + sessionSettings[sessionSettings.length - 1]*3600000 + result.data.sessionDuration;
                if(result.data.timestamp < endTime)
                {
                    NetManager.ins.addTimeShare((success,resultShare) => {
                        if(success && resultShare)
                        {
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:2});
                        }
                        else
                        {
                            //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太过火爆，请稍后重试'});
                            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                        }
                    });
                }
                else
                {
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }
            } 
        })
    }
    private closePanel(e:egret.TouchEvent){
      
        if(this.friendBtn != e.target && this.weChatBtn != e.target)
        {
            this.hidePanel();
            console.log("取消分享");
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        }
    }
}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}