import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from '../ctrls/panelCtrl';
export default class RulePanel extends Panel {
    public ruleGroup:eui.Group;
    public ruleLb:eui.Label;
    public closeBtn:eui.Button;

    public get skinKey() { return 'RulePanel' }
    public get groupName() { return 'rule_panel' }

    constructor(data: any) {
        super(data);
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.pMask.visible = false;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        // this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    removeEvents(): void {
        super.removeEvents();
        // this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    private onLoad():void{
        // NetManager.ins.getRule(function(success){

        //     if(success){
        //         //使用 HtmlTextParser 解析html文本
        //         this.ruleLb.textFlow = new HtmlTextParser().parse(DataManager.ins.getRuleData.ruleText);
        //     }else{
        //         this.ruleLb.text = '规则'
        //     }
        // }.bind(this));
        // this.ruleLb.textFlow = new HtmlTextParser().parse(DataManager.ins.ajaxElementDataNew.rule);
        //this.ruleLb.size = window['ruleFontSize'] ? window['ruleFontSize'] : 30;
        //this.ruleLb.text = '活动时间：\n2019年6月28日-2019年7月1日\n每天上午10:00-12:00\n\n活动对象：\n苏州银行手机银行注册客户\n活动内容：\n活动期间内，客户登录手机银行即可获得参与“红包雨”活动抢红包的机会，分享好友可增加抢红包的机会。\n\n活动规则：\n1、 活动期间，用户登录手机银行，每天均有1次抢红包机会，当天活动时间内分享好友参与活动，即可增加一次抢红包的机会；\n2、抢到现金红包的客户，需复制中奖红包券码，前往“苏州银行”微信公众号领取现金红包。（领取步骤：1、关注“苏州银行”微信公众号—点击“苏式精彩”菜单栏—进入“红包兑换”领取现金奖励；2、关注“苏州银行”微信公众号，回复“红包雨”获得兑换红包链接），活动结束后中奖情况可在手机银行-生活-红包雨进行查看，最晚领奖时间为2019年7月12日23:59:59，逾期作废；\n3、此活动为概率中奖，奖品数量有限，祝好运！\n4、如有疑问，可直接联系客服专线：400-090-0208（工作日9:00至18:00）；\n5、用户如果违反诚实守信原则或出现违规行为（包括但不限于侵犯第三人合法权益、作弊、扰乱系统、实施网络攻击、恶意套取、批量注册、用机器注册账户、用机器模拟客户端等方式），一经发现我行有权终止该用户参与活动并取消其领奖资格；\n6、活动中如有突发事件，苏州银行将调整活动时间和奖品设置，并及时以活动公告的形式告知用户；\n7、本活动与苹果公司无关。';
        // this.ruleLb.text = '活动主题：感恩母亲节 献花赢好礼\n\n活动玩法：\n\n从3种鲜花中选择其中一种给母亲献花，每次献花扣除9积分，点击选择花束后，小女孩手捧鲜花走向母亲，献花成功后直接抽奖，概率出奖，奖品有限，快来参与吧~\n\n活动奖品：\n18积分        概率：30%\n28积分        概率：10%\n38积分        概率：3%\n88积分        概率：2%\n188积分      概率：1%\n\n活动细则：\n\n1.每个会员可使用9积分参与1次游戏，参与后积分不予退回，次数不限。\n\n2.优惠券可在全国屈臣氏实体门店，消费购物结账时，出示相关的中奖奖品券码进行核销兑换。\n\n3.结果以“活动首页-我的奖励”或在屈臣氏“会员中心-积分乐园-兑换记录”中的中奖记录为准。\n\n4.券类奖品的使用规则详见每个优惠券的介绍页。\n\n5.实物类商品请凭券码到屈臣氏门店领取。\n\n6.在本次活动期间，如用户存在任何违反法律、法规、屈臣氏活动规则的行为，包括但不限于作弊得奖、恶意套现等行为，屈臣氏有权取消用户的中奖资格，收回所发奖品，要求用户将已享受的奖品退还屈臣氏，如奖品为实体奖品且用户已拆除外包装无法进行二次销售的，屈臣氏有权按照奖品的市场价格向用户追讨。\n\n7.本次活动规则如有调整，相关变动或调整将即时公布在本活动规则页面。\n\n8.活动期内，如遇兑换异常等不确定情况出现，请在活动结束后10个工作日内致电会员服务热钱：400 830 1310（自付市内话费）。\n\n9.此活动奖品数量有限，概率出奖，先到先得，祝好运～';
        this.ruleLb.stroke = 0;
        this.ruleLb.text = window['rule'];
    }
    private onTap_closeBtn(){
        PanelCtrl.instance.btnDelay(this.closeBtn);
        this.hidePanel();
    }
    
}