import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import PanelCtrl from "../ctrls/panelCtrl";
import { Buried } from '../../libs/tw/util/Buried';
export default class RankPanel extends Panel {
    public rankScroller:eui.Scroller;
    public myGroup:eui.Group;
    public rankGroup:eui.Group;
    public returnBtn:eui.Button;
    public closeBtn:eui.Button;

    public myRankLb:eui.Label;
    public myNickNameLb:eui.Label;
    public myScoreLb:eui.Label;
    public rankTipsLb:eui.Label;
    public myIcon:eui.Image;
    public bgImg:eui.Image;

    public get skinKey() { return 'RankPanel' }
    public get groupName() { return 'rank_panel' }

    constructor(data: any) {
        super(data);
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('rankBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        // this.returnBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_returnBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        // this.returnBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_returnBtn, this);
    }

    private onLoad():void{
        this.bgImg.texture = this.bgtexture;


        this.initUI();
    }

    private initUI():void{
        this.initRankList();


        
    }

    private initRankList():void{
        const rankDt = DataManager.ins.getRankListNewData.data.userRankList;
        const userDt = DataManager.ins.getRankListNewData.data.currentUserRankInfo;

        if(!rankDt || !rankDt.length){
            this.rankTipsLb.visible = true;

            this['myTipsLb'].text = '您还没有游戏数据！';
            this.myNickNameLb.text = '';
            this.myScoreLb.text = '';
            this.myRankLb.text = '';
        }else{
            this.rankTipsLb.visible = false;

            for(let i = 0; i < rankDt.length; i++){
                const group = new eui.Group();
                group.height = 80;
                let rData = rankDt[i];
    
                const img0 = new eui.Image();
                img0.source = rData.avatar;//'https://yun.duiba.com.cn/db_games/activity/img/shareImgTaohuaji.png';//
                img0.x = 80;
                img0.y = 5;
                img0.width = 70;
                img0.height = 70;
                group.addChild(img0);

                const maskRect = new egret.Shape();
                maskRect.x = 115;
                maskRect.y = 40;
                maskRect.graphics.beginFill(0);
                maskRect.graphics.drawCircle(0, 0, 30);
                maskRect.graphics.endFill();
                group.addChild(maskRect);

                img0.mask = maskRect;
    
                //排名
                const lb0 = new eui.Label();
                lb0.text = rData.rank + '';
                lb0.textColor = 0x6be7a6;
                lb0.textAlign = egret.HorizontalAlign.CENTER;
                lb0.width = 82;
                lb0.size = 50;
                lb0.y = 15;
                lb0.bold = true;
                lb0.italic = true;
                group.addChild(lb0);
    
    
                const lb1 = new eui.Label();//昵称
                const lb2 = new eui.Label();//分数
    
                lb2.x = 360;
                lb2.y = 25;
                lb2.width = 150;
                lb2.textAlign = egret.HorizontalAlign.CENTER;
                lb2.text = rData.maxScore + '';
                lb2.textColor = 0x6be7a6;
                group.addChild(lb2);
    
                lb1.x = 130;
                lb1.y = 25;
                lb1.width = 182;
                lb1.textAlign = egret.HorizontalAlign.CENTER;
                lb1.textColor = 0x6be7a6;
                group.addChild(lb1);

                var nName:string = rData.nickName;
                if(nName.length > 6){
                    nName = nName.substring(0, 3) + '***';
                }
                lb1.text = nName;
    
                if(i > 0){
                    group.y = i * group.height + 8;
                }else{
                    group.y = 8;
                }
                
    
                var lineImg = new eui.Image();
                lineImg.source = 'line_png';
                lineImg.y = 79;
                lineImg.x = 25;
                lineImg.height = 2;
                group.addChild(lineImg);
    
                this.rankGroup.addChild(group);
            }

            //初始化当前用户数据

            var nName:string = userDt.nickName;
            if(nName.length > 6){
                nName = nName.substring(0, 3) + '***';
            }
            this.myNickNameLb.text = nName;
            this.myIcon.source = userDt.avatar;//'https://yun.duiba.com.cn/db_games/activity/img/shareImgTaohuaji.png';//
            this.myScoreLb.text = userDt.maxScore;
            this.myRankLb.text = userDt.rank;

            
            this.myIcon.x = 206;
            this.myIcon.y = 11;
            this.myIcon.width = 70;
            this.myIcon.height = 70;

            const maskRect = new egret.Shape();
            maskRect.x = 241;
            maskRect.y = 46;
            maskRect.graphics.beginFill(0);
            maskRect.graphics.drawCircle(0, 0, 30);
            maskRect.graphics.endFill();
            this.myIcon.mask = maskRect;
            this.myGroup.addChild(maskRect);
        }



        // this.totalScoreLb.textFlow = [
		// 	{ text: "累计最高:" },
		// 	{ text: rankDt.myUserData.maxScore + '', style: { "textColor": 0xff84eb } }
		// ];
    }


    private onTap_returnBtn():void{
        console.log('点击了立即领取');
        PanelCtrl.instance.btnDelay(this.returnBtn);

    }
    
    onTouchTap():void{
        super.onTouchTap();

    }
}