import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { ModuleType } from '../../libs/tc/enum/ModuleType';
export default class PrizePanel extends Panel {
    private mdata: any;
   

    public share:eui.Group;
    public unShare:eui.Group;

    public closeBtn:eui.Button;
    public shareBtn:eui.Button;
    public getBtnUnShare: eui.Button;
    public getBtn:eui.Button;
    public prizeImg:eui.Image;

    public copyBtn:eui.Button;
    public rmbNumLb:eui.Label;
    public prizeNameLb: eui.Label;

   
    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }
    onSkinComplete(): void {
        super.onSkinComplete();
        this.pMask.visible = false;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.getBtnUnShare.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.getBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
        
    }

    removeEvents(): void {
        super.removeEvents();
        if(this.getBtnUnShare){
            this.getBtnUnShare.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
        if(this.getBtn){
            this.getBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
        if(this.shareBtn){
            this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
        }

        if(this.closeBtn){
            this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        }
    }

    private onLoad() {
        if(this.mdata){
            let idata = DataManager.ins.getData('getInformation').data;
            console.log("奖品数据",this.mdata,idata);
            if(idata.canShare){
                this.unShare.visible = false;
                this.share.visible = true;
                const startDpmOut2 = Buried.connectDpm(110, 6, 1); // 点击埋点   
                const startDcmOut2 = Buried.connectDcm(202, 0, 0); // 曝光埋点
                const exposure2 = Buried.createExposure(startDpmOut2, startDcmOut2);
        
                NetManager.ins.showLog(exposure2);

                console.log("打开界面分享界面");
            }else{
                this.unShare.visible = true;
                this.share.visible = false;
            }
        }
        if(this.mdata && this.mdata.data.prizeId != 'thanks'){
           
            console.log("奖品ID",this.mdata.data.prizeId);
            NetManager.ins.getPrizeDetail((success,result) => {
                console.log("奖品数据",success,result);
                if(success && result)
                {
                    
                    this.showPrize(result.data[0]);
                }
                else
                {
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太过火爆，请稍后重试'});
                }
            },this.mdata.data.prizeId)
        }

    }
    private showPrize(lottery){
        if(!lottery)
        {
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太过火爆，请稍后重试'});
            return;
        }
        var url: string;
        url = lottery.icon;
        this.prizeImg.name = 'img'

        this.prizeNameLb.text = lottery.name;//511 239
        this.prizeImg.source = url;
        this.prizeImg.width = 250;
        this.prizeImg.height = 250;
        console.log('奖品图',lottery.icon);
    }
    onUse() {
  
    }

    private onTap_ok(e:egret.TouchEvent):void{//立即领取
        PanelCtrl.instance.btnDelay(e.target);
        console.log("立即领取");
        if(!window['inApp'])
        {
            console.log("端外立即领取");
            PanelCtrl.instance.show(ModuleTypes.TIME_TIPS_PANEL);
        }
        else
        {
            console.log("端内立即领取");
            window.location.href = this.mdata.data.url ? this.mdata.data.url : 'http://activity.m.duibadev.com.cn/projectx/p8503e3aa/f5c695a60.html';
        }
    }

    private onTap_closeBtn():void{
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
    private onTap_shareBtn():void{
        console.log("立即分享");
        PanelCtrl.instance.btnDelay(this.shareBtn);
        const startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        const exposure = Buried.createExposure(startDpmOut, startDcmOut);
        NetManager.ins.clickLog(exposure);
        if(window['inApp'])
        {
            PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL); 
        }
        else
        {
            PanelCtrl.instance.show(ModuleTypes.TIME_TIPS_PANEL,{type:1}); 
        }
    }
}