
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from './../types/sceneTypes';
import BuriedCtrls from "../ctrls/BuriedCtrls";

export default class MsgPanel extends Panel {
    private mData:any;

    public closeBtn:eui.Button;
    public content1:eui.Label;
    public content2:eui.Label;
    public closeBtnLab:eui.Label;
    public msgCloseBtn:eui.Button;
    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.pMask.visible = false;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
		}
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
        this.msgCloseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickMsgCloseBtn,this);
    }

    removeEvents():void{
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
        this.msgCloseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickMsgCloseBtn,this);
    }

    private onLoad():void{
        //积分不足
        if(this.mData && this.mData.type == 1)
        {
            this.closeBtnLab.text = '获得积分';
            this.content1.text = '很遗憾，你的积分不足';
            this.content2.text = '快去获取更多积分吧';
            if(!this.mData.dpm){
                console.log('积分不足埋点出错');
                return;
            }
            BuriedCtrls.instance.showLogBuried(7,this.mData.dpm);
        }
        //其它异常
        if(this.mData && this.mData.type == 2)
        {
            this.content1.text = this.mData.content;
            this.closeBtnLab.text = '知道了';
        }
    }

    private onClickBtn(e:egret.TouchEvent):void{
        PanelCtrl.instance.btnDelay(this.closeBtn);
        if(this.mData && this.mData.type == 1)
        {
            console.log('跳转链接');
            if(!this.mData.dpm){
                console.log('积分不足埋点出错');
            }else{
                BuriedCtrls.instance.clickLogBuried(7,this.mData.dpm);
            }
            window.location.href = 'oppocommunity://www.oppo.cn?url=https://www.oppo.cn/app/task/unfinish';
            return;
        }
        if(this.mData && this.mData.buttonType == 'login'){
            // if(window['loginJs'])
            // {
            //     console.log('后端配置跳转',window['loginJs']);
            //     let callApp =  eval(window['loginJs']);
            //     callApp;
            // }else{
                //+ encodeURIComponent(window.location.href)
                console.log('唤起登录');
                if(/oppocommunity/i.test(navigator.userAgent))
                {
                    window['RainbowBridge'].callMethod("OPlusJSCommondMethod", "login", null, function(res) {
                        if (res.status.code == 0) {
                            window.location.href = window['callAppLink'] ;
                        }
                    })
                }
            //}
            return;
        }
        if(this.mData && this.mData.type == 2)
        {
            console.log('异常弹窗跳转 积分活动页');
            window.location.href = 'oppocommunity://www.oppo.cn?url=https://www.oppo.cn/app/task/unfinish';
            return;
        }
    }
    private onClickMsgCloseBtn(){
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}