import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Loading from "../loading/Loading";

import { ModuleTypes } from '../types/sceneTypes';
import SceneCtrl from '../ctrls/sceneCtrl';
import { Buried } from '../../libs/tw/util/Buried';

import { GDispatcher } from '../../libs/tc/util/GDispatcher';

import { Subject } from '../startScene/Subject';
import { HTime } from '../startScene/HTime';

export default class GameScene extends Scene {

    private mData;
    public gameBg:eui.Image;
    public questionBg:eui.Image;
    public countDownLab:eui.Label;
    public countLab:eui.Label;
    public questionLab:eui.Label;

    public errorBg:eui.Image;
    public wrong:eui.Image;
    public checkMark:eui.Image;
    public correctBg:eui.Image;

    private questionIndex:number = 0;//题目下标
    private questionData:any = null;//题库内容
    
    private answerTrueArray:Array<string>;
    private timeNumber:number = 10; 

    private gameBgTexture:egret.Texture;
    private questionBgTexture:egret.Texture;

    private isTouchEvent:boolean = false;
    private answerUserArray:Array<string>;
    private answerLab1:eui.Label;
    private answerLab2:eui.Label;
    private answerLab3:eui.Label;
    private answerLab4:eui.Label;

    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }
    
    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
        this['answerGroup1'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
        this['answerGroup2'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
        this['answerGroup3'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
        this['answerGroup4'].addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
    }

    removeEvents() {
        super.removeEvents();
        this['answerGroup1'].removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
        this['answerGroup2'].removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
        this['answerGroup3'].removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
        this['answerGroup4'].removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTapAnswer,this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.gameBg.texture = this.gameBgTexture;
        this.questionBg.texture = this.questionBgTexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.gameBgTexture = await RES.getResAsync('gameBg_jpg');
        this.questionBgTexture = await RES.getResAsync('questionBg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.mData = data;
        this.percentHeight = 100;

    }

    private onLoad(): void {
        window['sceneIndex'] = 2;
        GDispatcher.dispatchEvent('hashchange',null);
        GDispatcher.addEvent('onBack', this.onBack, this)
        this.answerUserArray = [];
        this.answerTrueArray = [];
        this.answerLab1 = this['answerGroup1'].getChildByName('answerLab');
        this.answerLab2 = this['answerGroup2'].getChildByName('answerLab');
        this.answerLab3 = this['answerGroup3'].getChildByName('answerLab');
        this.answerLab4 = this['answerGroup4'].getChildByName('answerLab');

        this.questionLab.fontFamily = 'OPPOSans_J';
        this.answerLab1.fontFamily = 'OPPOSans_S';
        this.answerLab2.fontFamily = 'OPPOSans_S';
        this.answerLab3.fontFamily = 'OPPOSans_S';
        this.answerLab4.fontFamily = 'OPPOSans_S';

        this.updateAnswer();
        if(this.mData && this.mData.question)
        {
            this.questionLab.text = '题目';
            this.questionData = Subject.getSubject(this.mData.question);
            if(this.questionData){
                this.updateUI();
            }
        }
 
    }
    private onBack(){
        console.log('点击返回键');
        this.countDownDestroy();
    }
    private initAnswerUI(){
        
        this.errorBg.visible = false;
        this.wrong.visible = false;
        this.checkMark.visible = false;
        this.correctBg.visible = false;
    }
    private updateUI(){
        this.initAnswerUI();
        this.updateQuestion();
        this.updatecountDown();
    }
    //获取答案
    private updateAnswer(){
        // let storageData = this.getLocalStorage();
        // if(storageData){
        //     this.answerTrueArray = storageData.split(",");
        //     console.log('本地缓存答案',this.answerTrueArray);
        // }else{
        //     NetManager.ins.getAnswer((success,result) => {
        //         if(this.netError(success,result))
        //         {
        //             this.answerTrueArray = result.data;
        //             this.setLocalStorage(this.answerTrueArray);
        //             console.log('更新后端答案',result.data);
        //         }
        //     },this.mData.question,(this.questionIndex + 1))
        // }

        NetManager.ins.getAnswer((success,result) => {
            if(this.netError(success,result))
            {
                this.answerTrueArray = result.data;
                // this.setLocalStorage(this.answerTrueArray);
                console.log('更新后端答案',result.data);
            }
        },this.mData.question,(this.questionIndex + 1));
    }
    private setLocalStorage(answerData){
        const answerTrueArray = answerData.join();
        localStorage.setItem(this.mData.question,answerTrueArray);
    }
    private getLocalStorage(){

        const result = localStorage.getItem(this.mData.question);
        if(!result){
            return null;
        }
        return result;
    }
    //更新题目
    private updateQuestion(): void {
        let config: {
            title: string,
            answer: Array<string>,
        } = this.questionData[this.questionIndex];
        
        this.countLab.text = (this.questionIndex + 1) + '/' + Object.keys(this.questionData).length;
     
        this.questionLab.text = config.title;
      

        this.answerLab1.text = config.answer[0];
        this.answerLab2.text = config.answer[1];
        this.answerLab3.text = config.answer[2];
        this.answerLab4.text = config.answer[3];
       
 
    }
    private updatecountDown(): void {
        this.timeNumber = window['countDownTime']?window['countDownTime']:10;
        this.countDownLab.text = this.timeNumber.toString();
        HTime.startHTime(()=>{
            this.submit();
        },()=>{
            this.timeNumber -= 1;
            this.countDownLab.text = this.timeNumber.toString();
        },this.timeNumber*1000,1000,false)
    }

    private countDownDestroy(){
        HTime.countDownDestroy();
    }

    private onTapAnswer(e:egret.TouchEvent):void{
        if(!this.isTouchEvent)
        {
            this.isTouchEvent = true;
            let buttonTmp = e.target;
            let answerClick = buttonTmp.name.substr(buttonTmp.name.length-1,1);
            this.judgeAnswer(answerClick,buttonTmp);
        }
    }
    private judgeAnswer(answerClick,buttonTmp){
        if(this.answerTrueArray.length < 10){
            console.log('获取答案数据出错');
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:2,content:'网络异常，请稍后重试～'});
            return;
        }
        this.answerUserArray.push(answerClick);
        this.countDownDestroy();
        if(answerClick == this.answerTrueArray[this.questionIndex]){
            this.handleAnserUI(true,buttonTmp)
            if(this.questionIndex >= 9)
            {
                setTimeout(() => {
                    if(window['isClearance'].indexOf(this.mData.question) > -1){
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    }else{
                        this.submit();
                    }
                }, 500);
            }else{
                setTimeout(() => {
                    this.questionIndex++;
                    this.updateUI();
                    this.isTouchEvent = false;
                    buttonTmp.removeChild(buttonTmp.getChildByName('checkMark'));
                    buttonTmp.removeChild(buttonTmp.getChildByName('correctBg'));
                }, 500);
            }
        }else{
            this.handleAnserUI(false,buttonTmp);
            console.log('打错题库-'+this.mData.question,'当前第几题'+(this.questionIndex+1),'正确答案是-'+this.answerTrueArray[this.questionIndex],'用户选择是-'+answerClick);
            setTimeout(() => {
                this.submit();
            }, 500);
        }
    }
    private submit(){
        let answerAllString:string = this.answerUserArray.join();
        answerAllString = answerAllString?answerAllString:"";
        console.log('当前用户全部答案-'+answerAllString);
        let getCredits = window['getCredits'][this.mData.question];
        if(getCredits <= 0){
            console.log('获取奖励积分出错');
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{type:2,content:'网络异常，请稍后重试～'});
            return;
        }
        let creditsSubmit2 = window['creditsSubmit2']?window['creditsSubmit2']:30;
        let creditsSubmit1 = window['creditsSubmit1']?window['creditsSubmit1']:10;
        if(getCredits == creditsSubmit2){
            this.doSubmit1(getCredits,answerAllString);
        }
        if(getCredits == creditsSubmit1){
            this.doSubmit2(getCredits,answerAllString);
        }
    }
    //30积分提交成绩
    private doSubmit2(getCredits,answerAllString){
        NetManager.ins.doSubmit2((success,result) => {
            if(this.netError(success,result))
            {
                this.handleResult(getCredits);
            }
        },window['ticketNum'],this.mData.question,answerAllString);
    }
    //6积分提交成绩
    private doSubmit1(getCredits,answerAllString){
        NetManager.ins.doSubmit1((success,result) => {
            if(this.netError(success,result))
            {
               this.handleResult(getCredits);
            }
        },window['ticketNum'],this.mData.question,answerAllString);
    }
    //本地处理当前用户时候答题通过
    private handleResult(getCredits){
        let addCredits:boolean = this.arrayEquals(this.answerTrueArray,this.answerUserArray);
        let dpm = parseInt(this.mData.question.substr(this.mData.question.length-1,1));
        if(addCredits){
            PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL,{result:2,credits:getCredits,dpm:dpm});
        }else{
            PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL,{result:1,dpm:dpm});
        }
    } 

    private arrayEquals(array1,array2) {
        return array1.length==array2.length && array1.every(function(v,i) { return v === array2[i]});
    }
    private netError(success,result){
        if (!result) {
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
            return false;
        }
        if(!success){
            if(result.code == '100001' || result.code == '00000001'){
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'您尚未登录，请先登录～',buttonType:'login'});
            }else{
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2,content:'网络异常，请稍后重试～'});
            }
            return false;
        }
        return true;
    }

    private handleAnserUI(result,buttonNode){
        if(result){
            this.trueAnswer(buttonNode);
        }else{
            this.errorAnswer(buttonNode);
            this.trueAnswer(this['answerGroup' + this.answerTrueArray[this.questionIndex]]);
        }
    }
    private trueAnswer(buttonNode){
        if(!buttonNode){
            console.log('true节点出错');
            return;
        }
        buttonNode.addChild(this.correctBg);
        buttonNode.setChildIndex(this.correctBg, buttonNode.numChildren - 2);
        this.correctBg.x = 0;
        this.correctBg.y = 0;
        this.correctBg.visible = true;
        buttonNode.addChild(this.checkMark);
        this.checkMark.x = 508;
        this.checkMark.y = 4;
        this.checkMark.visible = true;
        buttonNode.setChildIndex(this.checkMark, buttonNode.numChildren - 1);
    }
    private errorAnswer(buttonNode){
        if(!buttonNode){
            console.log('error节点出错');
            return;
        }
        buttonNode.addChild(this.errorBg);
        buttonNode.setChildIndex(this.errorBg, buttonNode.numChildren - 2);
        this.errorBg.x = 0;
        this.errorBg.y = 0;
        this.errorBg.visible = true;
        buttonNode.addChild(this.wrong);
        this.wrong.x = 508;
        this.wrong.y = -4;
        this.wrong.visible = true;
        buttonNode.setChildIndex(this.wrong, buttonNode.numChildren - 1);
    }
     
}