import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import BuriedCtrls from "../ctrls/BuriedCtrls";
export default class GameOverPanel extends Panel {
    private mData:any;
    public overGoAppBtn:eui.Button;

    public failGroup:eui.Group;
    public successGroup:eui.Group;
    public creditsLab:eui.Label;
    public closeBtn:eui.Button;
    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.pMask.visible = false;
        this.showAct();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();

        this.overGoAppBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onOverGoAppBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickCloseBtn,this);
    }

    removeEvents():void{
        super.removeEvents();
        this.overGoAppBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onOverGoAppBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onClickCloseBtn,this);
 
    }

    private onLoad():void{
        this.failGroup.visible = false;
        this.successGroup.visible = false;
        if(this.mData){
            switch(this.mData.result){
                case 1:
                    this.failGroup.visible = true;
                    if(!this.mData.dpm){
                        console.log('答题失败埋点出错');
                        return;
                    }
                    BuriedCtrls.instance.showLogBuried(8,this.mData.dpm);
                    break;
                case 2:
                    this.successGroup.visible = true;
                    this.creditsLab.text = '获得' + this.mData.credits + '积分';
                    if(!this.mData.dpm){
                        console.log('答题成功埋点出错');
                        return;
                    }
                    BuriedCtrls.instance.showLogBuried(9,this.mData.dpm);
                    break;
            }
        }
    }
    private onClickCloseBtn(){
        PanelCtrl.instance.btnDelay(this.closeBtn);
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        this.hidePanel();
    }
    private onOverGoAppBtn(){
        PanelCtrl.instance.btnDelay(this.overGoAppBtn);
        console.log('返回首页');
        if(this.mData && this.mData.result == 1){
            if(!this.mData.dpm){
                console.log('答题失败埋点出错');
                return;
            }
            BuriedCtrls.instance.clickLogBuried(8,this.mData.dpm);
        }
        if(this.mData && this.mData.result == 2){
            if(!this.mData.dpm){
                console.log('答题成功埋点出错');
                return;
            }
            BuriedCtrls.instance.clickLogBuried(9,this.mData.dpm);
        }
        window.location.href = 'oppocommunity://www.oppo.cn?url=https://www.oppo.cn/app/task/unfinish';
    }
    onTouchTap():any{
        super.onTouchTap();
    }
}