import { GCache } from './../libs/tc/util/GCache';
import { Buried } from './../libs/tw/util/Buried';

import layers from "./views/layers";
import { getResPath } from "./utils";
import AssetAdapter from "./AssetAdapter";
import ThemeAdapter from "./ThemeAdapter";
import { DataManager } from "../libs/tw/manager/DataManager";
import Loading from "./loading/Loading";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from './types/sceneTypes';
import { NetManager } from '../libs/tw/manager/NetManager';
import MsgPanel from './msgPanel/MsgPanel';
import GameScene from './gameScene/GameScene';
import PrizePanel from './prizePanel/PrizePanel';
import GameOverPanel from './gameOverPanel/GameOverPanel';
import SharePanel from './sharePanel/SharePanel';
import StartScene from './startScene/StartScene';

import { Subject } from './startScene/Subject';

import RulePanel from './rulePanel/RulePanel';
import ToastPanel from './toastPanel/ToastPanel';

import { GDispatcher } from '../libs/tc/util/GDispatcher';
import TimeDownPanel from './timeDownPanel/TimeDownPanel';

class Main extends eui.UILayer {
    protected createChildren(): void {
        super.createChildren();
        // alert(1)

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        //遇到输入框注释掉这个代码
        // egret.lifecycle.onPause = () => {
        //     egret.ticker.pause();
        // }

        // egret.lifecycle.onResume = () => {
        //     egret.ticker.resume();
        // }

        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        // 老游戏
        // DataManager.ins.gameCfgData = window['CFG'];
        // DataManager.ins.gameCfgData.gameInfo.gameId = window['gameId'];

        //GCache.init([DataManager.ins.customCfgData.actId + '', DataManager.ins.customCfgData.consumerId + '']);

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);

        DataManager.ins.getGameInfoData = {};
        window['CFG'] = {};
        if (window['isdebug']) {
            window['CFG'].projectId = '/projectx';
        } else {
            window['CFG'].projectId = '/projectx' + '/' + window.location.pathname.split('/')[2];
        }
        Buried.init();
        Buried.appId = window['appid'] ? window['appid'] : 69162;
        Buried.oaId = window.location.pathname.split('/')[2];

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;
        SceneCtrl.instance.registerSceneClass(ModuleTypes.GAME_SCENE, GameScene);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);

        PanelCtrl.instance.registerPanelClass(ModuleTypes.MSG_PANEL, MsgPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.TIMEDOWN_PANEL, TimeDownPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.TOAST_PANEL, ToastPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.GAMEOVER_PANEL, GameOverPanel);
  
        //this.initHistoryHash();

        GDispatcher.addEvent('hashchange', this.initHistoryHash, this)
        this.runGame().catch(e => {
            console.log(e);
        })
    }
    private initHistoryHash(){
        if (!window.location.hash) {
            window.history.pushState({ page: 1 }, '', "#/mine/rechargel");  
        }
        this.initListener();
    }
    private initListener(){
        window.onpopstate = function(event) {
            console.log('返回事件',event);
            let tmpPanel = PanelCtrl.instance.getCurPopup();
            if(tmpPanel){
                tmpPanel.hidePanel();
            }
            GDispatcher.dispatchEvent('onBack',null);
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
          };
    }
    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        this.resErrorListener();
        // RES.loadGroup("msg", 10);
    }

    private resErrorListener(): void {
        //添加资源组加载失败事件
        // RES.addEventListener(RES.ResourceEvent.GROUP_LOAD_ERROR, this.onResourceError, this);
        // //添加资源加载失败事件
        // RES.addEventListener(RES.ResourceEvent.ITEM_LOAD_ERROR, this.onResourceError, this);
    }

    private onResourceError(): void {
        let msg = '请刷新重试';
        // if(PanelCtrl.instance.isLoseCoin){
        //     msg = '请联系客服找回积分';
        // }else{
        //     msg = '请刷新重试';
        // }
        // console.log('isLoadedMsg' + PanelCtrl.instance.isLoadedMsg);

        if (PanelCtrl.instance.isLoadedMsg) {

            //PanelCtrl.instance.showMsg('okBtn', 4, null, null, msg);

        } else {
            alert('网络开小差了\n' + msg);
        }

        
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);
        })
    }
  
    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        //获取游戏信息
        Loading.instace.show();
        this.getGameRes();
    }
    /**
     * 创建场景界面
     * Create scene interface
     */
    private async getGameRes(){
        //获取游戏信息
        //await RES.loadGroup('font');
        await RES.loadGroup('start_scene');
        await RES.getResAsync('downBg_jpg');
        await RES.getResAsync('question_1_jpg');
        await RES.getResAsync('question_2_jpg');
        await RES.getResAsync('question_3_jpg');
        await RES.getResAsync('question_4_jpg');
        await RES.getResAsync('titleBg_jpg');
  
        Loading.instace.show();
        NetManager.ins.getDomain((success,result) => {
            console.log("getDomain",success,result);
            if (!result) {
                //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后重试～'});
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                return;
            }
            if(!success){
                if(result.code == '100001'){
                    //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'您尚未登录，请先登录～'});
                    //PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }else{
                    //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，请稍后重试～'});
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {type:2, content:'网络异常，请稍后重试～'});
                }
                return;
            }
            
            window['CFG'].domainUrl = DataManager.ins.getData('getDomain').data.activityDomain;
            if (!window['isdebug']) {
                window['CFG'].projectId = window['CFG'].domainUrl + window['CFG'].projectId;
            }
            Subject.initQuestion();
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
        await RES.loadGroup('common');

        await RES.getResAsync('timedownBg_jpg');
        await RES.loadGroup('timedown_panel');
        await RES.loadGroup('gameOver_panel');
        await RES.getResAsync('popupBg_jpg');
        await RES.loadGroup('msg_panel');
        await RES.loadGroup('rule_panel');
        await RES.getResAsync('ruleBg_jpg');
        await RES.loadGroup('game_scene');
        await RES.getResAsync('gameBg_jpg');
        await RES.getResAsync('questionBg_jpg');
    }
    
}

window['Main'] = Main;