import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class OutWinPanel extends Panel {

    public panelGroup: eui.Group;
    public bg: eui.Image;
    public titleImg: eui.Image;
    public drawBtn: eui.Button;
    public closeBtn: eui.Button;
    public msgImg: eui.Image;


    private mdata: any;

    public get skinKey() { return 'OutWin' }
    public get groupName() { return 'outwin_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        // 端外成功闯关埋点
        let drawDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let drawDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(drawDpmOut, drawDcmOut);

        NetManager.ins.showLog(exposure);

        this.closeBtn.visible = false;
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.drawBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_drawBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.drawBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_drawBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    onTap_drawBtn() {
        // 调起app 跳转抽奖链接

        // 端外成功闯关埋点
        let drawDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let drawDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(drawDpmOut, drawDcmOut);

        NetManager.ins.clickLog(exposure);

        setTimeout(() => {
            window.location.href = window['MPBankGiftLink'] + '&wechatid=' + DataManager.ins.getInfoData.uid + '&shareid=' + DataManager.ins.getInfoData.uid;
        }, 200)

    }

    onTap_closeBtn() {
        // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        // 端外 活动首页
        window.location.href = `${window['outIndexLink']}`
    }
}