export default function DefaultCallback<T extends { new(...arg: any[]): {} }>(target: T) {
    return class extends target {
        constructor(...arg: any[]) {
            super();
            this["onUpdate"] = this["onUpdate"] || (() => { });
            this["onLoad"] = this["onLoad"] || (() => { });

            this["addEventListener"](egret.Event.ENTER_FRAME, this["onUpdate"], this);
            this["addEventListener"](egret.Event.ADDED_TO_STAGE, this["onLoad"], this);
            this["addEventListener"](egret.Event.REMOVED_FROM_STAGE, () => {
                this["removeEventListener"](egret.Event.ENTER_FRAME, this["onUpdate"], this);
                this["removeEventListener"](egret.Event.ADDED_TO_STAGE, this["onLoad"], this)
                this["onDestroy"] && this["onDestroy"]();
            }, this);
        }
    }
}