"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var Buried_1 = require("../../libs/tw/util/Buried");
var GuidePanel_1 = require("../guidePanel/GuidePanel");
var SignInScene = (function (_super) {
    __extends(SignInScene, _super);
    function SignInScene() {
        return _super.call(this) || this;
    }
    Object.defineProperty(SignInScene.prototype, "skinKey", {
        //设置加载emxl的路径名字
        get: function () { return 'SignInScene'; },
        enumerable: true,
        configurable: true
    });
    SignInScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.signInBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    };
    SignInScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.signInBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    };
    SignInScene.prototype.start = function (data) {
        this.percentHeight = 100;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        this.guideBack = data;
        if (this.guideBack) {
            this.showGuide(2);
        }
    };
    SignInScene.prototype.onLoad = function () {
        //设置签到ui初始
        this.setSignInDay();
    };
    SignInScene.prototype.onClick_signInBtn = function () {
        console.log('点击签到');
        NetManager_1.NetManager.ins.doSign(function () {
            var acmDays = DataManager_1.DataManager.ins.signInfoData.signInfoVO.acmDays;
            this['awardState' + acmDays].visible = true;
            this.signInBtn.enabled = false;
            // DataManager.ins.signInfoData.signInfoVO.acmDays = acmDays + 1;
            // DataManager.ins.signInfoData.signInfoVO.todaySigned = true;
            DataManager_1.DataManager.ins.signInfoData.signInfoVO.rewardMap; //奖品列表
        }.bind(this), 555555, 66666);
        //点击埋点，确认签到
        var dpm = Buried_1.Buried.connectDpm(110, 4, 1);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
        this.guideLayer.visible = false;
    };
    SignInScene.prototype.setSignInDay = function () {
        var acmDays = DataManager_1.DataManager.ins.signInfoData.signInfoVO.acmDays;
        for (var i = 0; i < 7; i++) {
            if (i < acmDays) {
                this['awardState' + i].visible = true;
            }
            else {
                this['awardState' + i].visible = false;
            }
        }
        this.signInBtn.enabled = !DataManager_1.DataManager.ins.signInfoData.signInfoVO.todaySigned;
        this.pMsgLb.text = '已连续签到' + acmDays + '天';
    };
    SignInScene.prototype.onClick_hidePanel = function () {
        _super.prototype.hidePanel.call(this);
        if (this.guideBack) {
            this.guideBack(3);
        }
    };
    SignInScene.prototype.showGuide = function (index) {
        if (!this.guideLayer) {
            this.guideLayer = new GuidePanel_1.default();
            this.addChild(this.guideLayer);
        }
        this.guideLayer.visible = true;
        var x = this.signInBtn.x;
        var y = this.height - this['con'].bottom - this.signInBtn.bottom;
        var w = 422;
        var h = 125;
        this.guideLayer.updateData(index, x, y, w, h);
    };
    return SignInScene;
}(Panel_1.default));
exports.SignInScene = SignInScene;
__reflect(SignInScene.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/signInPanel/SignInSceneSkin\".SignInScene");
//# sourceMappingURL=SignInSceneSkin.js.map