"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var Buried_1 = require("../../libs/tw/util/Buried");
var GuidePanel_1 = require("../guidePanel/GuidePanel");
var PropPanel = (function (_super) {
    __extends(PropPanel, _super);
    function PropPanel() {
        return _super.call(this) || this;
    }
    Object.defineProperty(PropPanel.prototype, "skinKey", {
        //设置加载emxl的路径名字
        get: function () { return 'PropPanel'; },
        enumerable: true,
        configurable: true
    });
    PropPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.buyBtn0_prop.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_buyBtn0_prop, this);
        this.closeBtn1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_closeBtn1, this);
        this.downBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_downBtn, this);
        this.upBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_upBtn, this);
        this.buyCostBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_buyCostBtn, this);
    };
    PropPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.buyBtn0_prop.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_buyBtn0_prop, this);
        this.closeBtn1.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_closeBtn1, this);
        this.downBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_downBtn, this);
        this.upBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_upBtn, this);
        this.buyCostBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_buyCostBtn, this);
    };
    PropPanel.prototype.start = function (data) {
        this.percentHeight = 100;
        this.guideBack = data;
        if (this.guideBack) {
            this.showGuide(9);
        }
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
    };
    PropPanel.prototype.onLoad = function () {
        this.showBuyPop(false);
        var aToys = DataManager_1.DataManager.ins.getActToysListData;
        if (aToys && aToys[3]) {
            var gdList = aToys[3];
            if (gdList.toyList && gdList.toyList.length) {
                this.gd = gdList.toyList[0];
                this.prop0num.text = 'x' + this.gd.purchasedCount;
                if (this.gd.purchasedCount) {
                    this.buyBtn0_prop.label = '使用';
                }
                else {
                    this.buyBtn0_prop.label = '购买';
                }
                this.pNum.text = '1';
                this.costLb.text = '花费:' + this.gd.cost * 1 + DataManager_1.DataManager.ins.petIndexData.creditsUnitName;
            }
        }
    };
    PropPanel.prototype.onClick_buyBtn0_prop = function () {
        var _this = this;
        if (this.buyBtn0_prop.label == '使用') {
            NetManager_1.NetManager.ins.toyUse_xiecheng(function () {
                _this.gd.purchasedCount -= 1;
                if (!_this.gd.purchasedCount) {
                    _this.buyBtn0_prop.label = '购买';
                }
                _this.prop0num.text = 'x' + _this.gd.purchasedCount;
                GDispatcher_1.GDispatcher.dispatchEvent('useComplete');
            }, DataManager_1.DataManager.ins.petIndexData.activityId, this.gd.identifier, this.gd.id);
            if (this.guideBack) {
                this.hideGuide();
                this.hidePanel();
            }
        }
        else {
            this.showBuyPop(true);
        }
        //点击埋点，使用/购买 按钮
        var dpm = Buried_1.Buried.connectDpm(110, 5, 1);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
    };
    PropPanel.prototype.onClick_closeBtn1 = function () {
        this.showBuyPop(false);
    };
    PropPanel.prototype.onClick_downBtn = function () {
        this.ctlBuyNum(false);
    };
    PropPanel.prototype.onClick_upBtn = function () {
        this.ctlBuyNum(true);
    };
    //购买，并发送购买接口
    PropPanel.prototype.onClick_buyCostBtn = function () {
        var cost = Number(this.pNum.text) * this.gd.cost;
        if (cost <= DataManager_1.DataManager.ins.petIndexData.credits) {
            this.showBuyPop(false);
            NetManager_1.NetManager.ins.toyExchanges(function () {
                DataManager_1.DataManager.ins.petIndexData.credits -= cost;
                this.gd.purchasedCount += Number(this.pNum.text);
                this.pNum.text = '1';
                this.costLb.text = '花费:' + this.gd.cost * 1 + DataManager_1.DataManager.ins.petIndexData.creditsUnitName;
                this.buyBtn0_prop.label = '使用';
                this.prop0num.text = 'x' + this.gd.purchasedCount;
                GDispatcher_1.GDispatcher.dispatchEvent('buyComplete');
            }.bind(this), this.gd.id, Number(this.pNum.text));
            //点击埋点，确认购买
            var dpm = Buried_1.Buried.connectDpm(110, 6, 1);
            var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
            var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
            var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
            NetManager_1.NetManager.ins.clickLog(exposure);
        }
        else {
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, ['您的' + DataManager_1.DataManager.ins.petIndexData.creditsUnitName + '不足！']);
        }
    };
    /**
     * 控制显示隐藏数量框
     * @param isshow true 显示购买数量框
     */
    PropPanel.prototype.showBuyPop = function (isshow) {
        this.mask0.visible = !isshow;
        this.mask1.visible = isshow;
        this.buyPopGroup.visible = isshow;
    };
    /**
     *
     * @param isUp true 为增加购买数量 false 为减少
     */
    PropPanel.prototype.ctlBuyNum = function (isUp) {
        var num = Number(this.pNum.text);
        if (isUp) {
            if ((num + 1) * this.gd.cost <= DataManager_1.DataManager.ins.petIndexData.credits) {
                num += 1;
            }
            else {
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, ['您的' + DataManager_1.DataManager.ins.petIndexData.creditsUnitName + '不足！']);
            }
        }
        else {
            if (num > 1) {
                num -= 1;
            }
        }
        this.pNum.text = num + '';
        this.costLb.text = '花费:' + this.gd.cost * num + DataManager_1.DataManager.ins.petIndexData.creditsUnitName;
    };
    PropPanel.prototype.showGuide = function (index) {
        this.hideGuide();
        if (!this.guideLayer) {
            this.guideLayer = new GuidePanel_1.default();
            this.addChild(this.guideLayer);
        }
        var x;
        var y;
        var w;
        var h;
        if (index == 9) {
            x = this.buyBtn0_prop.x;
            y = this.height - this.buyBtn0_prop.bottom + 60;
            w = 176;
            h = 66;
            // }else if(index == 10){//指向关闭按钮
            //     x = this['closeBtn'].x;
            //     y = this['closeBtn'].y;
            //     w = 55;
            //     h = 55;
        }
        this.guideLayer.updateData(index, x, y, w, h);
    };
    PropPanel.prototype.hideGuide = function () {
        if (this.guideLayer) {
            this.guideLayer.dispose();
            this.removeChild(this.guideLayer);
            this.guideLayer = null;
        }
    };
    return PropPanel;
}(Panel_1.default));
exports.PropPanel = PropPanel;
__reflect(PropPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/propPanel/PropPanel\".PropPanel");
//# sourceMappingURL=PropPanel.js.map