"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var MyCoinLogItem_1 = require("./MyCoinLogItem");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var Buried_1 = require("../../libs/tw/util/Buried");
/**
 * 我的金币界面
 */
var MyGoldCoinPanel = (function (_super) {
    __extends(MyGoldCoinPanel, _super);
    function MyGoldCoinPanel() {
        var _this = _super.call(this) || this;
        _this.listData = [];
        return _this;
    }
    Object.defineProperty(MyGoldCoinPanel.prototype, "skinKey", {
        get: function () { return 'MyGoldCoin'; },
        enumerable: true,
        configurable: true
    });
    MyGoldCoinPanel.prototype.start = function () {
        this.percentHeight = 100;
        this.init();
        //点击埋点，我的金币记录页
        var dpm = Buried_1.Buried.connectDpm(110, 7, 1);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.showLog(exposure);
    };
    MyGoldCoinPanel.prototype.init = function () {
        this.lock = false;
        this.curPage = 1;
        this.listData = [];
        var credits = DataManager_1.DataManager.ins.petIndexData.credits + '';
        this.numTxt.text = credits;
        this.coinIcon.x = Math.min((credits.length * 60 + this.numTxt.x), 450);
        this.linkTxt.textFlow = new Array({ text: '赚金币>', style: { underline: true } });
        this.ary = new eui.ArrayCollection();
        var list = new eui.List();
        list.dataProvider = this.ary;
        list.itemRenderer = MyCoinLogItem_1.default;
        list.width = 640;
        list.height = 270;
        this.addChild(list);
        this.list = list;
        this.list.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.move, this);
        var scroller = new eui.Scroller();
        this.scroller = scroller;
        this.scroller.viewport = this.list;
        this.addChild(this.scroller);
        this.scroller.x = 55;
        this.scroller.bottom = 27;
        this.updateData();
    };
    MyGoldCoinPanel.prototype.move = function (e) {
        var _this = this;
        var listH = this.listData.length * 80; //80是单个item的高度
        if (this.scroller.viewport.scrollV > (listH - 80 - this.list.height)) {
            if (this.lock) {
                return;
            }
            this.lock = true;
            this.curPage++; //当前页数+1
            NetManager_1.NetManager.ins.weOrder(function (success) {
                if (!success) {
                    return;
                }
                _this.lock = false;
                _this.updateData();
            }, DataManager_1.DataManager.ins.petIndexData.appId, DataManager_1.DataManager.ins.petIndexData.partnerUserId, this.curPage, 10, 'success');
        }
    };
    MyGoldCoinPanel.prototype.updateData = function () {
        this.setListData(DataManager_1.DataManager.ins.weOrderData.list);
        this.ary.replaceAll(this.listData);
    };
    /**
     * 更新当前列表的数据，把每次调接口获取的累加起来
     * @param d
     */
    MyGoldCoinPanel.prototype.setListData = function (d) {
        if (d) {
            for (var i = 0; i < d.length; i++) {
                this.listData.push(d[i]);
            }
        }
    };
    MyGoldCoinPanel.prototype.onClick_earnGoldCoinPanel = function (e) {
        this.hidePanel();
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.EARN_GOLD_COIN_PANEL);
    };
    MyGoldCoinPanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.linkTxt.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_earnGoldCoinPanel, this);
    };
    MyGoldCoinPanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.linkTxt.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_earnGoldCoinPanel, this);
    };
    return MyGoldCoinPanel;
}(Panel_1.default));
exports.default = MyGoldCoinPanel;
__reflect(MyGoldCoinPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/myGoldCoinPanel/MyGoldCoinPanel\".MyGoldCoinPanel");
//# sourceMappingURL=MyGoldCoinPanel.js.map