import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class PubPanel extends Panel {

    public panelGroup: eui.Group;
    public bg: eui.Image;
    public againBtn: eui.Button;
    public closeBtn: eui.Button;
    public msgImg: eui.Image;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'PubPanel' }
    public get groupName() { return 'pub_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        // 端内 再来一次 埋点
        let againDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let againDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let againExposure = Buried.createExposure(againDpmOut, againDcmOut);

        NetManager.ins.showLog(againExposure);
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    onTap_againBtn() {
        // 端内 再来一次 埋点
        let againDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let againDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let againExposure = Buried.createExposure(againDpmOut, againDcmOut);

        NetManager.ins.clickLog(againExposure);

        console.log(DataManager.ins.getInfoData.status.code)
        if (DataManager.ins.getInfoData.status.code == 3) {
            // 参与次数已用完
            // 端内
            setTimeout(() => {
                PanelCtrl.instance.showMsg('okBtn', 6, null, null, () => {
                    // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
                    window.location.href = `${window['appIndexLink']}`
                }, () => {
                    // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
                    window.location.href = `${window['appIndexLink']}`
                });
            }, 200)
            return;
        } else if (DataManager.ins.getInfoData.status.code == 2) {
            // 积分不足
            // 端内
            setTimeout(() => {
                PanelCtrl.instance.showMsg('okBtn', 6, null, null, () => {
                    // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
                    window.location.href = `${window['appIndexLink']}`
                }, () => {
                    // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
                    window.location.href = `${window['appIndexLink']}`
                });
            }, 200)
            return;
        } else if (DataManager.ins.getInfoData.status.code == 1) {
            // 未登录
            PanelCtrl.instance.showMsg('loginBtn', 2, null, null, function () {

            });
            return;
        } else {
            Loading.instace.show();
            NetManager.ins.doStart(function (success: boolean) {
                if (success) {
                    NetManager.ins.getStartStatus(
                        (data) => {
                            console.log('data轮询失败=' + data);
                            Loading.instace.hide();
                            if (data == 'pollingFaild' || !data) {//统一处理异常？？？？？？？
                                PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试~');
                                // Loading.instace.show();
                                return
                            } else {
                                //开始游戏
                                // PanelCtrl.instance.removeImmediately();
                                this.scene.currLevel = 0;
                                this.scene.isRevived = false;
                                this.scene.revive();
                                this.hidePanel();
                                // PanelCtrl.instance.isLoseCoin = true;
                                // this.hideLevelTitleAct();
                            }
                        },
                        DataManager.ins.doStartData.ticketId,
                        () => { return DataManager.ins.getStartStatusData.code == 0; },
                        10);
                } else {
                    Loading.instace.hide();
                    console.log('dostart失败');
                    //统一处理异常？？？？？？？
                    PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试！');
                }
            }.bind(this), false);
        }

    }

    onTap_closeBtn() {
        // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        window.location.href = `${window['appIndexLink']}`
    }
}