import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class RecheckPanel extends Panel {

    public panelGroup: eui.Group;
    public bg: eui.Image;
    public titleImg: eui.Image;
    public continueBtn: eui.Button;
    public refuseBtn: eui.Button;
    public closeBtn: eui.Button;
    public msgImg: eui.Image;

    private mdata: any;

    public get skinKey() { return 'Recheck' }
    public get groupName() { return 'recheck_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        // 拒绝按钮埋点
        let refuseDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let refuseDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let refuseExposure = Buried.createExposure(refuseDpmOut, refuseDcmOut);

        NetManager.ins.showLog(refuseExposure);

        // 继续游戏按钮埋点
        let continueDpmOut = Buried.connectDpm(110, 7, 2); // 点击埋点   
        let continueDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let continueExposure = Buried.createExposure(continueDpmOut, continueDcmOut);

        NetManager.ins.showLog(continueExposure);
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.continueBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_continueBtn, this);
        this.refuseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.continueBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_continueBtn, this);
        this.refuseBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    onTap_continueBtn() {
        // 继续游戏按钮埋点
        let continueDpmOut = Buried.connectDpm(110, 7, 2); // 点击埋点   
        let continueDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let continueExposure = Buried.createExposure(continueDpmOut, continueDcmOut);

        NetManager.ins.clickLog(continueExposure);
        // 调起app 跳转获取次数链接
        setTimeout(() => {
            window.location.href = window['MPBankAPPLink'] + '&wechatid=' + DataManager.ins.getInfoData.uid + '&shareid=' + DataManager.ins.getInfoData.uid;
        }, 200)

    }

    onTap_closeBtn() {
        // 拒绝按钮埋点
        let refuseDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let refuseDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let refuseExposure = Buried.createExposure(refuseDpmOut, refuseDcmOut);

        NetManager.ins.clickLog(refuseExposure);

        this.hidePanel()
        // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        // 端外 活动首页
        window.location.href = `${window['outIndexLink']}`
    }
}