import { GameGetSubmitResultData } from '../../libs/tw/data/game/submit/GameGetSubmitResultData';
import { GetInfoData } from '../../libs/tw/data/game/getInfo/GetInfoData';
import Panel from "../views/Panel";
import MItem from '../components/MItem';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { NetPromise } from '../NetPromise';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetName } from '../../libs/tw/enum/NetName';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { NetBuried } from '../NetBuried';
import { CloseWin } from '../CloseWin';
import GameConst from '../GameConst';

export default class TaskListItem extends MItem {

    public btn_1:eui.Button;
    public btn_1_1:eui.Button;
    public btn_1_2:eui.Button;
    public btn_2:eui.Button;
    public btn_3:eui.Button;
    public taskTitleText:eui.Label;
    public taskTitleText0:eui.Label;
    public taskDeskText:eui.Label;
    


    constructor(id) {
        super();
    }
   
    dataChanged(){
        this.btn_1.visible=false;
        this.btn_1_1.visible=false;
        this.btn_1_2.visible=false;
        this.btn_2.visible=false;
        this.btn_3.visible=false;

        this.taskTitleText0.visible=false;
        this.taskTitleText.visible=false;
        this.taskDeskText.visible=false;

        console.log("this.data")
        console.log(this.data)

        if(this.data.status==0||this.data.status==1||this.data.status==2){
            this["btn_"+(this.data.status+1)].visible=true;
            if(this.data.status==0&&(this.data.type=="inviteManager"||this.data.type=="inviteSleep"||this.data.type=="sell"||this.data.type=="order")){
                if(NetPromise.ins.isWeiXin()){
                    this.btn_1.visible=false;
                    this.btn_1_1.visible=false;
                    this.btn_1_2.visible=false;
                    if(this.data.type=="sell"||this.data.type=="order"){
                        this.btn_1_2.visible=true
                    }else{
                        this.btn_1_1.visible=true;
                    }
                }else{
                    this.btn_1_1.visible=false;
                    this.btn_1_2.visible=false;
                    this.btn_1.visible=true;
                }
            }
        }

        /* if(this.data.type=="qd"){
            this.taskTitleText0.visible=true;
            this.taskTitleText0.text="每日签到奖励"
        }else{ */
            this.taskTitleText.visible=true;
            this.taskDeskText.visible=true;
        //}

        /* assistance：助力  browse：浏览  sell：销售  order：购买  inviteManager：邀请店主 inviteVip：邀请vip  inviteSleep：邀请沉睡用户 */

        if(this.data.type=="assistance"){
            this.taskTitleText.text="邀请好友助力"
        }else if(this.data.type=="browse"){
            this.taskTitleText.text="浏览指定商品得奖励"
        }else if(this.data.type=="sell"){
            this.taskTitleText.text="销售指定商品得奖励"
        }else if(this.data.type=="order"){
            this.taskTitleText.text="购买指定商品得奖励"
        }else if(this.data.type=="inviteManager"){
            this.taskTitleText.text="邀请店主"
        }else if(this.data.type=="inviteVip"){
            this.taskTitleText.text="邀请VIP下首单"
        }else if(this.data.type=="inviteSleep"){
            this.taskTitleText.text="邀请沉睡中的用户"
        }

        if(this.data.type=="assistance"){
            if(this.data.completed<=0){
                this.taskDeskText.text=`累计奖励${this.data.rewardAmount}牛草，每日${this.data.total}次`
            }else if(this.data.completed<this.data.total){
                this.taskDeskText.text=`累计奖励${this.data.rewardAmount}牛草，剩余${this.data.total-this.data.completed}次`
            }else if(this.data.completed>=this.data.total){
                this.taskDeskText.text=`累计奖励${this.data.rewardAmount}牛草，剩余0次`
            }
        }else{
            if(this.data.completed<=0){
                this.taskDeskText.text=`奖励${window["prizeList"][this.data.type]}牛草，每日${this.data.total}次`
            }else if(this.data.completed<this.data.total){
                this.taskDeskText.text=`奖励${window["prizeList"][this.data.type]}牛草，剩余${this.data.total-this.data.completed}次`
            }else if(this.data.completed>=this.data.total){
                this.taskDeskText.text=`奖励${window["prizeList"][this.data.type]}牛草，剩余0次`
            }
        }

        if(this.data.type=="qd"){
            this.taskTitleText.text="每日签到奖励"
            this.taskDeskText.text=window["signDesk"]
        }
    }

    onSkinComplete(){
        

        //去完成按钮
        this.btn_1.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_1,this)
        this.btn_1_1.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_1,this)
        this.btn_1_2.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_1,this)

        //领取按钮
        this.btn_2.addEventListener(egret.TouchEvent.TOUCH_TAP,()=>{
            if(this.data.type=="qd"){
                NetBuried.ins.clickLog(3)
            }else if(this.data.type=="assistance"){
                NetBuried.ins.clickLog(17)
            }else if(this.data.type=="browse"){
                NetBuried.ins.clickLog(6)
                
            }else if(this.data.type=="sell"){
                NetBuried.ins.clickLog(5)
               
            }else if(this.data.type=="order"){
                NetBuried.ins.clickLog(4)
               
            }else if(this.data.type=="inviteManager"){
                NetBuried.ins.clickLog(7)
               
            }else if(this.data.type=="inviteVip"){
                NetBuried.ins.clickLog(8)
            }else if(this.data.type=="inviteSleep"){
                NetBuried.ins.clickLog(9)
            }
            this.getDalingjiaTaskPrize(this.data.type)
        },this)
    }


    openSignWin(){
        GDispatcher.dispatchEvent(CloseWin.TaskPanel)
        NetPromise.ins.getSignInfo()
        .then(()=>{
            return NetPromise.ins.getCntSignInfo()
        })
        .then(()=>{
            return NetPromise.ins.getSignpetPushQuery()
        })
        .then(()=>{
            PanelCtrl.instance.show(ModuleTypes.SIGN_PANEL)
        })
        .catch(()=>{

        })
    }

    onTap_btn_1(){
        GDispatcher.dispatchEvent(CloseWin.TaskPanel)
        if(this.data.type=="qd"){
            this.openSignWin()
            NetBuried.ins.clickLog(3)

        }else if(this.data.type=="assistance"){
            NetBuried.ins.clickLog(17)
            this.doShare()

        }else if(this.data.type=="browse"){
            NetBuried.ins.clickLog(6)
            NetPromise.ins.setSignpetTaskBrowse()
            .then(()=>{
                if(NetPromise.ins.isWeiXin()){
                    window.location.href=`https://djia.daling.com/subject/e3ek2krd?inviteCode=${NetPromise.ins.inviteCode}`
                }else{
                    window["SDK"].goDifferentTask(3)
                }
            })
            .catch(()=>{})

        }else if(this.data.type=="sell"){
            NetBuried.ins.clickLog(5)
            if(NetPromise.ins.isWeiXin()){
                window.location.href=window["gotoAppLink"]
            }else{
            window["SDK"].goDifferentTask(2)
            }
            
        }else if(this.data.type=="order"){
            NetBuried.ins.clickLog(4)
            if(NetPromise.ins.isWeiXin()){
                window.location.href=window["gotoAppLink"]
            }else{
                window["SDK"].goDifferentTask(1)
            }
            
        }else if(this.data.type=="inviteManager"){
            NetBuried.ins.clickLog(7)
            if(NetPromise.ins.isWeiXin()){
                window.location.href=window["gotoAppLink"]
            }else{window["SDK"].goDifferentTask(5)}
        }else if(this.data.type=="inviteVip"){
            NetBuried.ins.clickLog(8)
            if(NetPromise.ins.isWeiXin()){
                window.location.href=`https://djia.daling.com/touch/invite-register-vip?inviteCode=${NetPromise.ins.inviteCode}`
            }else{
                window["SDK"].goDifferentTask(4)
            }
        }else if(this.data.type=="inviteSleep"){
            NetBuried.ins.clickLog(9)
            if(NetPromise.ins.isWeiXin()){
                window.location.href=window["gotoAppLink"]
            }else{window["SDK"].goDifferentTask(6)}
        }
    }

    //分享助力
    doShare(){
        if(NetPromise.ins.isWeiXin()) {
            PanelCtrl.instance.show(ModuleTypes.SHARE_TIPS_PANEL)
        }else{
            var category="asd";
            var shareInfo = window["shareInfo"]
            console.log(shareInfo.link+`&shareCode=${NetPromise.ins.shareCode}}`)
            console.log(shareInfo.img)
            console.log(shareInfo.title)
            console.log(shareInfo.desc)
            window["SDK"].shareOther(shareInfo.link+`&shareCode=${NetPromise.ins.shareCode}`, shareInfo.img, shareInfo.title, shareInfo.desc, "1");
            //window["SDK"].shareOther(window["url"]+`shareCode=${NetPromise.ins.shareCode}`, window["img"], window["title"], window["desc"], category);
        }
    }

    getDalingjiaTaskPrize(type){
        this.enabled=false
        console.log(type)
        let vipType
        let dcustom = GameConst.getCookie("dcustom");
        vipType=NetPromise.ins.getQueryVariable(dcustom, "vip")
        NetPromise.ins.getDalingjiaTaskPrize(type,vipType)
        .then(()=>{
            this.enabled=true;
            GDispatcher.dispatchEvent("updateTaskData")
            NetPromise.ins.showToast(`恭喜您获得牛草+${DataManager.ins.getData(NetName.GET_DALINGJIA_TASK_PRIZE).data.rewardAmount}g`)
        })
        .catch(()=>{
            this.enabled=true
        })
    }

}