import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import TaskItem from './TaskItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import { NetBuried } from '../NetBuried';

export default class StartScene extends Scene {

    public scroller_body:eui.Scroller;
    public bg:eui.Image;
    public topBtn:eui.Group;
    public ruleBtn:eui.Button;
    public disc_ico:eui.Image;
    public startBtn:eui.Button;
    public limitTodyText:eui.Label;
    public adList:eui.Label;    
    


    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        clearInterval(this.adTime)
    }

    onTap_recordBtn(){
        window.location.href=window["recordUrl"];
    }

    onTap_ruleBtn() {
        let ruleData = `1、微信端挑战机会用完后，可前往民生银行App获得更多挑战次数，
具体次数以App显示为准。挑战次数当日有效，隔日作废。
2、至民生银行App游戏闯关后，将有机会获得口红大奖、红包等好
礼，100%中奖！具体规则以民生银行App的活动规则为准。
3、未下载民生银行App的用户，可在微信端游戏结束后下载App，
并返回手机浏览器跳转页面，刷新后将进入民生银行App直接参与
活动。
4、非民生银行客户直接下载民生银行App，通过手机号注册并参与
活动。
5、本活动仅限上海地区客户参加，最终解释权归中国民生银行上海
分行所有。`
        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "ruleGroup", ruleData: ruleData })
    }

    onTap_detailBtn() {
        this.enabled = false;
        NetPromise.ins.detailDo()
            .then(() => {
                this.enabled = true;
                SceneCtrl.instance.change(ModuleTypes.RED_SCENE)
            })
            .catch(() => {
                this.enabled = true;
            })
    }

    onTap_startBtn() {
        PanelCtrl.instance.btnDelay(this.startBtn)
        NetBuried.ins.clickLog(2)
        if(localStorage.times==new Date().getDate()){
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"noTimesGroup"})
            console.log("次数已用完弹窗")
            return;
        }
        localStorage.times=new Date().getDate()
        const isfirst = egret.localStorage.getItem('showGuide');
        if (!isfirst) {
            egret.localStorage.setItem('showGuide', 'true');
            PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
        } else {
            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
        }
    }

    adTime

    protected onSkinComplete(): void {
        super.onSkinComplete();
        

        // this.mainbg.texture = this.bgtexture;
        let stageHeight = 750 / window.innerWidth * window.innerHeight;
        this.scroller_body.height = stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        let i_a=0

        NetBuried.ins.showLog(1)
        NetBuried.ins.showLog(2)
        this.adList.text=window["adList"][i_a]
        this["adlistShow"].play(0)
        i_a++
        this.adTime=setInterval(()=>{
            this.adList.text=window["adList"][i_a]
            this["adlistShow"].play(0)
            if(i_a>=window["adList"].length-1){
                i_a=0
            }else{
                i_a++
            }
        },2250)

        this.animation()
        if(localStorage.times==new Date().getDate()){
            this.limitTodyText.text=`今天剩余次数:0次`
        }else{
            this.limitTodyText.text=`今天剩余次数:1次`
        }
    }

    animation() {
        this["disc_loop"].play(0)
        this["disc_loop"].items.forEach((item) => {
            item.tween.loop = true;
        })
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {

    }
    private canStart: boolean;

}