import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import RedItem from './RedItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';

export default class RedScene extends Scene {

    public scroller_body: eui.Scroller;
    public bg: eui.Image;
    public totalText: eui.Label;
    public voucherText: eui.Label;
    public redTipsText: eui.Label;
    public list: eui.List;
    public convertBtn: eui.Button;
    public backBtn: eui.Button;



    public get skinKey() { return 'RedScene' }
    public get groupName() { return 'red_scene' }

    constructor(data?) {
        super(data);
        this.data = DataManager.ins.getData(NetName.detailDo).data;
    }

    initEvents() {
        super.initEvents();
        this.convertBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_convertBtn, this)
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this)
    }

    removeEvents() {
        super.removeEvents();
        this.convertBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_convertBtn, this)
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this)
    }

    onTap_backBtn(){
        NetPromise.ins.timesDo()
        .then((e)=>{
            console.log(e)
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
        .catch((e)=>{
            PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试');
        })
    }

    onTap_startBtn() {
        const isfirst = egret.localStorage.getItem('showGuide');
        if (!isfirst) {
            egret.localStorage.setItem('showGuide', 'true');
            PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
        } else {
            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
        }
    }

    onTap_convertBtn() {

        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"convertSureGroup"})
        NetPromise.ins.join3joinDo()
            .then((e) => {
                console.log("兑换成功")
            })
            .catch((e) => {
                console.error(e)
                console.log("兑换失败")
            })
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;
        let stageHeight = 750 / window.innerWidth * window.innerHeight;
        this.scroller_body.height = stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.animation()



        this.totalText.text = this.data.total.toFixed(2);
        this.voucherText.text = `预计可兑换代金券金额为${this.data.voucher}元`;
        this.list.itemRenderer = RedItem;
        this.list.dataProvider = new eui.ArrayCollection(this.data.details);


        if (this.data.endTime < new Date()) {
            //活动已结束
            this.convertBtn.enabled = true;
            this.redTipsText.text = "兑换后奖品将在活动结束后\n10个工作日内充值至相关账户"
        } else {
            //活动进行中
            this.convertBtn.enabled = false;
            this.redTipsText.text = "红包将于活动结束后统一兑换\n请于活动结束后5个工作日内兑换完成"
        }
        /* 
                this.list.itemRenderer=TaskItem;
                NetPromise.ins.listDo()
                .then(()=>{
                   
                })
                .catch(()=>{
        
                }) */

    }

    animation() {
        /*  this["disc_loop"].play(0)
         this["disc_loop"].items.forEach((item)=>{
             item.tween.loop=true;
         }) */
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {

    }
    private canStart: boolean;

}