import { TwFun } from './../../libs/tw/util/TwFun';
import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class PrizePanel extends Panel {
    private mdata: any;
    public panelGroup: eui.Group;
    public closeBtn: eui.Button;
    public bindCardBtn: eui.Button;
    public iknowBtn: eui.Button;
    public prizeNameLb: eui.Label;
    public prizeImg: eui.Image;
    public getPrizeTips: eui.Label;


    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();

        //立即领取埋点
        let useDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let useDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let useExposure = Buried.createExposure(useDpmOut, useDcmOut);

        NetManager.ins.showLog(useExposure);
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.bindCardBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.bindCardBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    private async onLoad() {
        var url: string = DataManager.ins.gameGetSubmitResultData.lottery.img;
        this.prizeNameLb.text = DataManager.ins.gameGetSubmitResultData.lottery.name;
        this.prizeImg.source = url;
        const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        if (lottery.type == LotteryType.OBJECT) {
            // 实物 口红
            this.iknowBtn.visible = true;
            this.getPrizeTips.visible = true;
            this.bindCardBtn.visible = false;
            this.prizeImg.y = 294;
            this.prizeNameLb.y = 550;
        } else if (lottery.type == LotteryType.COUPON) {
            // 优惠券  红包
            this.iknowBtn.visible = false;
            this.getPrizeTips.visible = false;
            this.bindCardBtn.visible = true;
            this.prizeImg.y = 311;
            this.prizeNameLb.y = 572;
        }
    }

    private onTap(): void {
        PanelCtrl.instance.btnDelay(this.iknowBtn);
        this.hidePanel();
        //获取游戏信息
        Loading.instace.show();
        NetManager.ins.getInfo((success: boolean) => {
            if (success) {
                if (this.mdata) {
                    this.mdata();
                }
            } else {
                //提示用户，返回上一层，重新进入活动？？？？？
                PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试！');
            }
            Loading.instace.hide();
        });
    }


    onUse() {

        //立即领取埋点
        let useDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let useDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let useExposure = Buried.createExposure(useDpmOut, useDcmOut);

        NetManager.ins.clickLog(useExposure);

        const lottery = DataManager.ins.gameGetSubmitResultData.lottery;
        // if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
        if (lottery.type == LotteryType.LUCKY) {

            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.gameGetSubmitResultData.exposure);
            }
        }
        else {
            console.log(`领奖链接：${lottery.link}`)
            if (lottery.type == LotteryType.COUPON) {
                // 中的是红包 跳绑卡页面
                // window.location.href = `https://hzweb.mbcloud.com/duiba/2019lady/gift.html?cmbid=${DataManager.ins.getInfoData.uid}`;
                window.location.href = `https://hzweb.mbcloud.com/mobbank/signin/index?activityID=14&appact=dbbcard`;
                // window.location.href = lottery.link;
            } else if (lottery.type == LotteryType.OBJECT) {
                // 中的是口红 跳奖品记录页
                // let prizePluginIds = [4398, 4399];
                // let recordUrl = window['recordUrl'] + '&origins=' + prizePluginIds.join('01,') + '01,' + 3392717 + '00';
                // window.location.href = TwFun.getRecordUrl('00');
                // window.location.href = recordUrl;
                window.location.href = "//activity.m.duiba.com.cn/crecord/record?dbnewopen&dpm=1.3.2.0&origins=439801,439901,339271700"
            } else {
                window.location.href = lottery.link;
            }
        }
    }

    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        // this.onTap();
        // 端内 活动首页
        window.location.href = `${window['appIndexLink']}`
    }
}