import { Buried } from './../../libs/tw/util/Buried';
import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import SceneCtrl from '../ctrls/sceneCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetManager } from '../../libs/tw/manager/NetManager';

export default class GuidePanel extends Panel {
    public act0:egret.tween.TweenGroup;
    public moveTurnBb:eui.Image;
    public actGroup:eui.Group;
    public handImg:eui.Image;
    public gTitle:eui.Label;
    public bgmask:eui.Rect;

    public get skinKey() { return 'Guide' }
    public get groupName() { return 'guide_panel'}

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct(function(){
            // this.showMaskAct();

            this.playRoolTurntable();
        }.bind(this));
    }

    start():void{
        this.percentHeight = 100;
        
    }

    initEvents():void{
        super.initEvents();
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{
        //引导曝光
        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        this.moveTurnBb.rotation    = -300;
        this.bgmask.visible         = false;

        this.setHandTitle(false);

        // var url:string          = DataManager.ins.gameGetSubmitResultData.lottery.img;
        // this.prizeNameLb.text   = DataManager.ins.gameGetSubmitResultData.lottery.name;
        // this.prizeImg.source    = url;
    }

    private onTap():void{
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
    }

    onTouchTap():any{
        super.onTouchTap();
        this.onTap();

        //引导点击
        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
    }

    //设置点击手势和提示文字
    private setHandTitle(isshow:boolean):void{
        this.handImg.visible = isshow;
        this.gTitle.visible = isshow;
    }

    //口红机转动动画
    private playRoolTurntable():void{
        egret.Tween.get(this.moveTurnBb).wait(300).to({rotation:34}, 500, egret.Ease.cubicOut).call(this.showMaskAct,this);
    }

    //遮罩动画
    private showMaskAct():void{

        this.bgmask.visible = true; 

        var shape:egret.Shape = new egret.Shape();
        shape.graphics.beginFill(0);
        shape.graphics.drawCircle(0,0,810);
        shape.graphics.endFill();

        this.panelGroup.addChild(shape);
        shape.x = 750 * 0.5 + 25;
        shape.y = 790;//810;

        this.actGroup.visible = true;
        this.actGroup.mask = shape;
        // shape.width = 1000;
        // shape.height = 1000;

        this.actGroup.mask = shape; 
        const endScale = 150 / 810;

        egret.Tween.get(shape).to({scaleX:endScale, scaleY:endScale},300,egret.Ease.cubicOut).call(function(){
            this.setHandTitle(true); 
            this.playAnimation(this.act0, true);
        }.bind(this));
    }

    //循环播放动画
	private playAnimation(target:egret.tween.TweenGroup,isLoop:boolean):void
	{
		if(isLoop)
		{
			for(var key in target.items)
			{
				target.items[key].props = {loop:true};
			}
		}
		target.play();
	}
}