import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';

export default class GameScene extends Scene {
    public bg:eui.Image;
public countDownBg:eui.Image;
public bulletCountLb:eui.Label;
public countDownLb:eui.Label;
public passActGroup:eui.Group;
public turnTableBg02:eui.Image;
public turnTableBg00:eui.Image;
public turnTableBg01:eui.Image;
public shootBulletImg:eui.Image;
public shootActGroup:eui.Group;
public turnGroup:eui.Group;
public bulletGroup:eui.Group;
public bulletBoxGroup0:eui.Group;
public bulletBoxGroup1:eui.Group;
public bulletBoxGroup2:eui.Group;
public bulletBoxGroup3:eui.Group;
public bulletBoxGroup4:eui.Group;
public bulletBoxGroup5:eui.Group;
public bulletBoxGroup6:eui.Group;
public bulletBoxGroup7:eui.Group;
public bulletBoxGroup8:eui.Group;
public bulletBoxGroup9:eui.Group;
public bulletBoxGroup10:eui.Group;
public bulletBoxGroup11:eui.Group;
public bulletBoxGroup12:eui.Group;
public bulletBoxGroup13:eui.Group;
public bulletBoxGroup14:eui.Group;
public bulletBoxGroup15:eui.Group;
public bulletBoxGroup16:eui.Group;
public bulletBoxGroup17:eui.Group;
public bulletBoxGroup18:eui.Group;
public bulletBoxGroup19:eui.Group;
public bulletBoxGroup20:eui.Group;
public bulletBoxGroup21:eui.Group;
public bulletBoxGroup22:eui.Group;
public bulletBoxGroup23:eui.Group;
public bulletBoxGroup24:eui.Group;
public bulletBoxGroup25:eui.Group;
public bulletBoxGroup26:eui.Group;
public bulletBoxGroup27:eui.Group;
public bulletBoxGroup28:eui.Group;
public bulletBoxGroup29:eui.Group;
public bulletBoxGroup30:eui.Group;
public bulletBoxGroup31:eui.Group;
public bulletBoxGroup32:eui.Group;
public turnTbBgImg:eui.Image;
public goodActGroup:eui.Group;
public goodActBg:eui.Image;
public goodActHand:eui.Image;
public clickGroup:eui.Group;
public gkIconImg1:eui.Label;
public gkIconImg2:eui.Label;
public gkIconImg3:eui.Label;
public goNextLevel:eui.Group;
public levelTitleImg:eui.Image;
public startBtn:eui.Button;


    private bEndY: number;
    private isOver: boolean;
    private bStartY: number;
    private isFail: boolean;
    private isRevived: boolean;
    private currLevel: number;
    private timeoutId: number;
    private canShoot: boolean;
    private timer: egret.Timer;
    private bulletCount: number;
    private timeDownNum: number;
    private levelCountArr: number[];
    private timeDownNumArr: number[];
    private gPlayModel: GamePlayModel;
    private xinxingAct: egret.MovieClip;
    private score: number = 1;

    private circleImg0: eui.Image;
    private circleImg1: eui.Image;
    private circleImg2: eui.Image;
    private circleImg3: eui.Image;
    private circleImg4: eui.Image;

    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        this.timer.addEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        this.clickGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);

    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_startBtn, this);
        this.clickGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onMainTap, this);
        this.timer.removeEventListener(egret.TimerEvent.TIMER, this.ontimer, this);
        this.timer.stop();//停止倒计时

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');


        var mcJson = await RES.getResAsync('xinxingAct_json');
        var mcImg = await RES.getResAsync('xinxingAct_png');
        var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        //游戏页曝光
        // let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.showLog(exposure);

        this.showAct();
        this.initUI();
    }

    private initUI(): void {
        this.initSceneData();
        this.refreshLevelIcon();

        this.createCircleImg();
        this.showLevelTitleAct(true);


        this.clickGroup.addChild(this.xinxingAct);

        this.xinxingAct.y = 100;
        this.xinxingAct.visible = false;
        // this.onloopReturn();
        // this.timer.start();

    }

    private canStart: boolean;

    private ontap_beforeStartBtn() {
        PanelCtrl.instance.btnDelay(this.startBtn);
        if (!this.canStart) return;
        let data = { scene: this }
        PanelCtrl.instance.show(ModuleTypes.WARNING_PANEL, data);
    }

    private ontap_startBtn(): void {
        PanelCtrl.instance.btnDelay(this.startBtn);
        if (!this.canStart) return;

        this.isOver = false;

        
        this.dostart();
        
    }


    //显示切换关卡页面
    private showLevelTitleAct(isshowBtn: boolean = false): void {
        if (this.currLevel == 0) {
            //第一关曝光
            let startDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);
        } else if (this.currLevel == 1) {
            //第二关曝光
            let startDpmOut = Buried.connectDpm(110, 13, 2); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);
        } else if (this.currLevel == 2) {
            //第三关曝光
            let startDpmOut = Buried.connectDpm(110, 13, 3); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);
        }

        this.levelTitleImg.source = 'gtitle' + this.currLevel + '_png';
        this.startBtn.visible = isshowBtn;
        this.goNextLevel.alpha = 0;
        this.goNextLevel.visible = true;

        egret.Tween.get(this.goNextLevel).to({ alpha: 1 }, 300).call(function () {
            this.canStart = true;

            if (!isshowBtn) {
                setTimeout(() => {
                    this.xinxingAct.visible = false;
                    this.hideLevelTitleAct();
                }, 500);
            }
        }, this);

        this.refreshTurnImg();
    }

    private refreshTurnImg(): void {
        this.turnTableBg00.source = 'turnTableBg' + this.currLevel + '0_png';
        this.turnTableBg01.source = 'turnTableBg' + this.currLevel + '1_png';
        this.turnTableBg02.source = 'turnTableBg' + this.currLevel + '2_png';
        this.turnTbBgImg.source = 'turnTableBg' + this.currLevel + '_png';
    }

    //隐藏切换关卡页面
    private hideLevelTitleAct(): void {
        egret.Tween.get(this.goNextLevel).to({ alpha: 0 }, 300).call(function () {
            this.canStart = false;
            this.goNextLevel.visible = false;
            this.onloopReturn();

            if (!this.isFail) {
                // this.onloopReturn();
            } else {
                // egret.Tween.resumeTweens(this.turnGroup);
                this.shootBulletImg.rotation = 0;
            }

            this.isFail = false;
            this.timer.start();
        }, this);
    }

    //初始化界面数据
    private initSceneData(): void {
        this.levelCountArr = window['bulletNum'] ? window['bulletNum'] : [5, 8, 12];
        this.timeDownNumArr = [12, 18, 25];


        this.bEndY = 174.5 + 401 + 441 - (750 * 0.5) - 20 + 107;//this.turnTbBgImg.y + this.turnTbBgImg.height + this.turnGroup.y - 20 + 107;
        this.bStartY = this.shootBulletImg.y;
        this.canShoot = true;
        this.currLevel = 0;
        this.gPlayModel = new GamePlayModel();
        this.bulletCount = this.levelCountArr[this.currLevel];
        this.timeDownNum = this.timeDownNumArr[this.currLevel];
        this.countDownLb.text = this.timeDownNum + 'S';
        this.goodActGroup.alpha = 0;
        this.bulletCountLb.text = 'X' + this.bulletCount;
        this.passActGroup.visible = false;

        this.gPlayModel.update();
    }

    //初始当前关数提示
    private refreshLevelIcon(): void {

        this.gkIconImg1.visible=false;
        this.gkIconImg2.visible=false;
        this.gkIconImg3.visible=false;

        this["gkIconImg"+(this.currLevel+1)].visible=true;
    }

    private onMainTap(e: egret.TouchEvent): void {
        if (!this.canShoot) return;
        console.log('onMainTap');
        console.log("this.bEndY=" + this.bEndY);
        //防作弊
        const dynamic: IDynamicData = { a: 'tap', t: GTime.getTimestamp(), x: e.stageY, y: e.stageY };
        this.gPlayModel.addDynamic(dynamic);

        this.canShoot = false;
        egret.Tween.get(this.shootBulletImg).to({ y: this.bEndY }, 200, egret.Ease.sineIn).call(function () {
            //减少口红数量
            this.bulletCount--;
            this.bulletCountLb.text = 'X' + this.bulletCount;

            //插入口红
            this.intoBullet();

            // egret.Tween.pauseTweens(this.turnGroup);
            // setTimeout(() => {
            //     // this.turnGroup.rotation += 360 / 33;
            //     egret.Tween.resumeTweens(this.turnGroup);
            // }, 1000);
        }, this);

    }
    //插入口红
    private intoBullet(): void {
        console.log('this.turnGroup.rotation=' + this.turnGroup.rotation);

        let angle = this.turnGroup.rotation;
        if (angle < 0) {
            angle = 360 + angle;
        }

        console.log('angle=' + angle);
        // let idx = Math.ceil(Math.floor(angle / (360 / 33) * 100) * 0.01) - 1;
        let idx = Math.floor(angle / (360 / 33));
        console.log('idx1=' + idx);

        if (idx == 0) {
            idx = 0;
            //矫正圆盘角度，插中的位置保持正对最下方
            this.turnGroup.rotation = 0;
        } else {
            //矫正圆盘角度，插中的位置保持正对最下方
            this.turnGroup.rotation = idx * (360 / 33);
            idx = 33 - idx;
        }


        console.log('idx=' + idx);
        const img = new eui.Image();
        img.source = 'bulletImg_png';
        const key = 'bulletBoxGroup' + idx;

        if (this[key].numChildren > 0) {
            if (this.isOver) return;

            this.isOver = true;
            PanelCtrl.instance.isLoseCoin = false;

            this.timer.stop();
            // egret.Tween.pauseTweens(this.turnGroup);

            clearTimeout(this.timeoutId);
            egret.Tween.removeTweens(this.turnGroup);

            console.log('游戏结束！');
            this.isFail = true;
            egret.Tween.get(this.shootBulletImg).to({ rotation: 50, y: this.shootBulletImg.y + 400 }, 300, egret.Ease.cubicOut).call(function () {

                this.gameOver()
                // NetManager.ins.gameSubmit(function(){}, 
                //     DataManager.ins.doStartData.ticketId,
                //     0,'[]',DataManager.ins.doStartData.submitToken,""
                // );
            }, this);
        } else {
            //判断是否成功插入
            if (this.bulletCount <= 0) {
                //进入下一关
                this.bulletCount = 0;
                this.canShoot = false;
                this.showCicleDownAct();
                this.timer.stop();
            }

            //圆盘震动
            egret.Tween.get(this.shootActGroup).to({ y: -10 }, 100, egret.Ease.sineIn).call(function () {
                egret.Tween.get(this.shootActGroup).to({ y: 0 }, 100, egret.Ease.sineIn).call(function () {

                }, this);
            }, this);

            //初始化子弹位置
            this.shootBulletImg.alpha = 0;
            this.shootBulletImg.y = this.bStartY + this.shootBulletImg.height;
            //子弹装弹动画 
            egret.Tween.get(this.shootBulletImg).to({ alpha: 1, y: this.bStartY }, 200, egret.Ease.sineIn).call(function () {
                if (this.bulletCount > 0) {
                    this.canShoot = true;
                }
                //可以继续发射了
            }, this);

            //子弹尾部动画
            this.showCircleAct();
            this[key].addChild(img);
            //good动画
            this.showGoodAct();
        }
    }


    private direct: number = 1;//Math.random() > 0.5 ? 1 : -1
    //随机转动
    private onloopReturn(): void {
        this.shootActGroup.visible = true;

        let offAngle = 0;

        let r = Math.random();
        if (r < 0.2) {
            offAngle = 10;
        } else if (r >= 0.2 && r < 0.6) {
            offAngle = 100;
        } else {
            offAngle = 40;
        }
        let endAngle = offAngle + Math.floor(100 * Math.random());
        let time = 1000;
        // if (this.isMPBank()) {
        //     time = 1000;
        // } else {
        //     time = 600;
        // }
        //100 + 1500 * Math.random(); //endAngle * (5 + 10 * Math.random());
        const endRot = this.turnGroup.rotation + endAngle * this.direct;

        //有时候会连续两次，给turngroup添加转动，到时候转动闪动
        egret.Tween.removeTweens(this.turnGroup);

        // const endRot = this.turnGroup.rotation + 200 * this.direct;
        egret.Tween.get(this.turnGroup).to({ rotation: endRot }, time, egret.Ease.getPowOut(0.9)).call(function () {
            if (this.direct > 0) {
                this.direct = -1;
            } else {
                this.direct = 1;
            }
            this.timeoutId = setTimeout(() => {
                this.onloopReturn();
            }, 100);
        }, this);
    }

    //创建子弹尾部动画元素
    private createCircleImg(): void {
        for (let i = 0; i < 5; i++) {
            this['circleImg' + i] = new eui.Image();
            this['circleImg' + i].source = 'khAct' + i + '_png';
            this['circleImg' + i].alpha = 0;

            this.addChild(this['circleImg' + i]);

        }
    }

    //播放子弹尾部圆圈动画
    private showCircleAct(): void {
        for (let i = 0; i < 5; i++) {

            this['circleImg' + i].alpha = 1;
            this['circleImg' + i].scaleX = 1;
            this['circleImg' + i].scaleY = 1;

            this['circleImg' + i].y = this.bEndY + 50;
            this['circleImg' + i].x = (750 - this['circleImg' + i].width) * 0.5;


            egret.Tween.removeTweens(this['circleImg' + i]);

            egret.Tween.get(this['circleImg' + i]).wait(300).to({ alpha: 0 }, 100);
        }

        this.circleImg0.x += 20;
        this.circleImg1.x -= 5;
        this.circleImg2.x -= 10;
        this.circleImg3.x += 10;
        this.circleImg2.x -= 20;

        const time = 400;
        egret.Tween.get(this.circleImg0).to({
            alpha: 0, scaleX: 1.2, scaleY: 1.2, x: this.circleImg0.x + 100, y: this.circleImg0.y + 350
        }, time, egret.Ease.cubicOut);

        egret.Tween.get(this.circleImg1).to({
            alpha: 0, scaleX: 1.2, scaleY: 1.2, x: this.circleImg1.x - 25, y: this.circleImg1.y + 400
        }, time, egret.Ease.cubicOut);

        egret.Tween.get(this.circleImg2).to({
            alpha: 0, scaleX: 1.2, scaleY: 1.2, x: this.circleImg2.x - 50, y: this.circleImg2.y + 350
        }, time, egret.Ease.cubicOut);

        egret.Tween.get(this.circleImg3).to({
            alpha: 0, scaleX: 1.2, scaleY: 1.2, x: this.circleImg3.x + 50, y: this.circleImg3.y + 400
        }, time, egret.Ease.cubicOut);

        egret.Tween.get(this.circleImg4).to({
            alpha: 0, scaleX: 1.2, scaleY: 1.2, x: this.circleImg4.x - 100, y: this.circleImg4.y + 380
        }, time, egret.Ease.cubicOut);


    }

    //good动效
    private showGoodAct(): void {
        egret.Tween.removeTweens(this.goodActGroup);
        egret.Tween.removeTweens(this.goodActHand);

        this.goodActGroup.scaleX = 0;
        this.goodActGroup.scaleY = 0;
        this.goodActGroup.alpha = 1;
        this.goodActGroup.rotation = 0;
        this.goodActGroup.y = 247;
        this.goodActHand.y = 59;

        //手，位移
        egret.Tween.get(this.goodActHand).wait(470).to({
            y: this.goodActHand.y + 25
        }, 90).to({
            y: this.goodActHand.y + 15
        }, 120);

        //缩放
        egret.Tween.get(this.goodActGroup).wait(60).to({
            scaleX: 1, scaleY: 1
        }, 190, egret.Ease.cubicOut).wait(710).to({
            scaleX: 0.7, scaleY: 0.7
        }, 100, egret.Ease.cubicOut);

        //旋转
        egret.Tween.get(this.goodActGroup).to({
            rotation: 1120
        }, 150, egret.Ease.cubicOut).to({
            rotation: 1066
        }, 90, egret.Ease.cubicOut).to({
            rotation: 1080
        }, 60, egret.Ease.cubicOut).wait(560).to({
            rotation: 1063
        }, 100, egret.Ease.cubicOut).to({
            rotation: 1108
        }, 100, egret.Ease.cubicOut);

        //透明度
        egret.Tween.get(this.goodActGroup).wait(990).to({ alpha: 0 }, 70);

        //位移
        egret.Tween.get(this.goodActGroup).wait(910).to({ y: this.goodActGroup.y - 50 }, 150);

    }

    private showCicleDownAct(): void {
        this.shootActGroup.visible = false;
        clearTimeout(this.timeoutId);
        egret.Tween.removeTweens(this.turnGroup);

        this.turnTableBg00.x = 202;
        this.turnTableBg01.x = 201;
        this.turnTableBg02.x = 201;
        this.turnTableBg00.y = 202;
        this.turnTableBg01.y = 201;
        this.turnTableBg02.y = 201;

        this.turnTableBg00.rotation = 0;
        this.turnTableBg01.rotation = 0;
        this.turnTableBg02.rotation = 0;

        this.passActGroup.visible = true;

        const time = 550;

        // this.xinxingAct.play(0);
        this.xinxingAct.gotoAndPlay(0);
        this.xinxingAct.x = 750 * 0.5;
        this.xinxingAct.y = 100 + 714 * 0.5;
        this.xinxingAct.anchorOffsetX = 750 * 0.5;
        this.xinxingAct.anchorOffsetY = 714 * 0.5;
        this.xinxingAct.scaleX = 1;
        this.xinxingAct.scaleY = 1;
        this.xinxingAct.visible = true;

        egret.Tween.get(this.xinxingAct).to({ scaleX: 1.4, scaleY: 1.4, y: this.xinxingAct.y + 600 }, time);
        egret.Tween.get(this.turnTableBg00).to({ x: 120, rotation: -90 }, time);
        egret.Tween.get(this.turnTableBg00).to({ y: this.turnTableBg00.y + 1250 }, time, egret.Ease.cubicIn);
        egret.Tween.get(this.turnTableBg01).to({ x: 360, rotation: 90 }, time);
        egret.Tween.get(this.turnTableBg01).to({ y: this.turnTableBg00.y + 1250 }, time, egret.Ease.cubicIn);
        egret.Tween.get(this.turnTableBg02).to({ x: 280, rotation: 50 }, time);
        egret.Tween.get(this.turnTableBg02).to({ y: this.turnTableBg00.y + 1250 }, time, egret.Ease.cubicIn).call(function () {
            this.xinxingAct.visible = false;
            if (this.currLevel == 2) {
                // 闯关成功
                this.xinxingAct.visible = false;
                if (this.isMPBank()) {
                    // 端内
                    this.score = 20;
                    // 分数为20出奖
                } else {
                    // 端外
                    this.score = 1;
                    // 分数为1不出奖
                }

                this.gameSubmit();
            } else {

                //刷新下一关信息
                this.canShoot = true;
                this.currLevel++;

                this.bulletCount = this.levelCountArr[this.currLevel];
                this.timeDownNum = this.timeDownNumArr[this.currLevel];
                this.countDownLb.text = this.timeDownNum + 'S';
                this.bulletCountLb.text = 'X' + this.bulletCount;

                this.refreshLevelIcon();
                // this.onloopReturn();
                this.clearAllBulletGroup();

                this.showLevelTitleAct();

                //防作弊
                // if (this.gPlayModel.checkDatapash(this.currLevel)) {
                //     this.gPlayModel.datapash();
                // }
            }
        }, this);

        // egret.Tween.get(this.turnTableBg01).to({y:this.turnTableBg00.y + 1200}, 500, egret.Ease.cubicIn);
        // egret.Tween.get(this.turnTableBg02).to({y:this.turnTableBg00.y + 1200}, 500, egret.Ease.cubicIn);
    }

    //清理所有已经插上的口红
    private clearAllBulletGroup(): void {
        for (let i = 0; i < 33; i++) {
            this['bulletBoxGroup' + i].removeChildren();
        }
    }

    private ontimer(): void {
        // console.log('this.turnGroup.rotation=' + this.turnGroup.rotation);
        //预览图片倒计时
        if (this.timeDownNum > 0) {
            this.timeDownNum--;
            this.countDownLb.text = this.timeDownNum + 'S';
            if (this.timeDownNum <= 0) {
                if (this.isOver) return;

                this.isOver = true;

                PanelCtrl.instance.isLoseCoin = false;
                this.gameOver();
            }
        }

    }

    //游戏失败处理
    private gameOver(): void {
        this.timer.stop();
        // egret.Tween.pauseTweens(this.turnGroup);
        clearTimeout(this.timeoutId);
        egret.Tween.removeTweens(this.turnGroup);

        console.log('游戏结束！');
        this.isFail = true;

        if (!this.isRevived) {
            this.isRevived = true;
            // 本局没有复活过出复活弹窗
            let data = { scene: this };
            PanelCtrl.instance.show(ModuleTypes.REVIVE_PANEL, data);
        } else {
            // 本局已经复活出再来一次弹窗
            NetManager.ins.gameSubmit((success) => {
                // if (!success) {
                //     // 提交没成功调用一次getinfo
                //     NetManager.ins.getInfo(() => {

                //     })
                // }
                let data = { scene: this }
                PanelCtrl.instance.show(ModuleTypes.OVER_PANEL, data)
            },
                DataManager.ins.doStartData.ticketId,
                1, '[]', DataManager.ins.doStartData.submitToken, ""
            );
        }
    }

    //游戏失败弹窗
    private callBack_gameover(): void {
        this.shootActGroup.visible = true;
        this.canShoot = true;
        this.currLevel = 0;

        this.bulletCount = this.levelCountArr[this.currLevel];
        this.timeDownNum = this.timeDownNumArr[this.currLevel];
        this.countDownLb.text = this.timeDownNum + 'S';
        this.bulletCountLb.text = 'X' + this.bulletCount;

        this.refreshLevelIcon();
        this.clearAllBulletGroup();
        this.showLevelTitleAct(true);
    }


    private dostart(): void {
        this.gPlayModel.datapash();
        this.isRevived = false;
        PanelCtrl.instance.isLoseCoin = true;
        this.hideLevelTitleAct();
    }

    private gameSubmit() {
        Loading.instace.show();
        NetManager.ins.gameSubmit((success: boolean) => {
            if (this.isMPBank()) {
                // 端内 判断接口是否成功
                if (!success) {
                    // 接口失败
                    Loading.instace.hide();
                    // 显示未中奖弹窗
                    let data = { scene: this }
                    PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL, data);
                    return
                }
                //回调捞结果
                NetManager.ins.getSubmitResult((data) => {
                    if (data == 'pollingFaild' || !data) {
                        //轮询失败  弹错误弹窗
                        PanelCtrl.instance.showMsg('okBtn', 4, null, null, () => {
                            // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
                            // 端内 活动首页
                            window.location.href = `${window['appIndexLink']}`

                        }, () => {
                            // SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
                            // 端内 活动首页
                            window.location.href = `${window['appIndexLink']}`
                        }, '请去【我的奖品】查看是否中奖~');
                    } else {
                        // 轮询成功  展示奖品
                        this.showPrizePanel();

                        PanelCtrl.instance.isLoseCoin = false;
                    }
                    Loading.instace.hide();
                },
                    DataManager.ins.gameSubmitData.orderId,
                    //轮询
                    () => {
                        return DataManager.ins.gameGetSubmitResultData.flag;
                    });
            } else {
                // 端外 不管捞结果  直接进调起app弹窗
                Loading.instace.hide();
                PanelCtrl.instance.show(ModuleTypes.OUTWIN_PANEL);
            }

        },
            DataManager.ins.doStartData.ticketId,
            this.score,
            '[]',
            DataManager.ins.doStartData.submitToken,
            JSON.stringify(this.gPlayModel.allDynamicsData),
            true
        )
    }

    private showPrizePanel(): void {
        //处理中奖情况
        if (DataManager.ins.gameGetSubmitResultData && DataManager.ins.gameGetSubmitResultData.lottery) {//中奖了
            PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL, this.callBack_gameover.bind(this));
        } else {
            //未中奖,（必中活动未中奖要做容错处理）
            let data = { scene: this };
            PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL, data);
        }
    }

    private errMsgCallBack() {
        if (!this.timer) {
            alert('网络开小差了\n请刷新重试！');
            return;
        }

        this.timer.stop();
        // egret.Tween.pauseTweens(this.turnGroup);
        console.log('游戏结束！');
        this.isFail = true;

        this.callBack_gameover();
    }

    // 复活
    public revive() {
        this.canShoot = true;
        this.isOver = false;

        this.bulletCount = this.levelCountArr[this.currLevel];
        this.timeDownNum = this.timeDownNumArr[this.currLevel];
        this.countDownLb.text = this.timeDownNum + 'S';
        this.bulletCountLb.text = 'X' + this.bulletCount;
        console.log(this.timeDownNum)

        this.refreshLevelIcon();
        // this.onloopReturn();
        this.clearAllBulletGroup();

        this.showLevelTitleAct();

        //防作弊
        if (this.gPlayModel.checkDatapash(this.currLevel)) {
            this.gPlayModel.datapash();
        }


        this.timer.start();
    }

    private isMPBank() {
        var ua = navigator.userAgent;
        // var ua = 'MPBank'
        if (ua.indexOf('MPBank') > -1)
            return true;
        else
            return false;
    }

}