import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetName } from "../libs/tw/enum/NetName";
import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";

export class NetPromise {
  private static instance: NetPromise;

  public static get ins(): NetPromise {
    if (!this.instance) {
      this.instance = new NetPromise();
    }
    return this.instance;
  }

  constructor() { }

  shareCode;
  inviteCode;

  Date=new Date();

  
  /**
   * 星速台-民生樱花口红机-获取剩余次数
   */
  timesDo() {
    return new Promise((resolve, reject) => {
      NetManager.ins.timesDo((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      })
    })
  }

  /**
   * 星速台-民生樱花口红机-抽奖
   */
  joinDo() {
    return new Promise((resolve, reject) => {
      NetManager.ins.joinDo((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      })
    })
  }

  /**
   * 星速台-民生樱花口红机-查询任务列表
   */
  listDo() {
    return new Promise((resolve, reject) => {
      NetManager.ins.listDo((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      })
    })
  }

  /**
   * 星速台-民生樱花口红机-查询红包明细
   */
  detailDo() {
    return new Promise((resolve, reject) => {
      NetManager.ins.detailDo((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      })
    })
  }

   /**
     * 星速台-民生樱花口红机-兑换优惠券
     */
  join3joinDo() {
      return new Promise((resolve, reject) => {
        NetManager.ins.join3joinDo((success) => {
          console.log(success)
          if (!success) {
            reject(success)
          }
          resolve(success)
        })
      })
    }

  /**
   * 星速台-民生樱花口红机-记录领奖详情
   */
  exchangeDo(prizeIds) {
    return new Promise((resolve, reject) => {
      NetManager.ins.exchangeDo((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      },prizeIds)
    })
  }

  /**
   * 星速台-查询奖品信息
   */
  prizeQuery(ids) {
    return new Promise((resolve, reject) => {
      NetManager.ins.prizeQuery((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      },ids)
    })
  }


  /**
   * 获取url cookie参数
   * @param url 
   * @param variable 
   */
  getQueryVariable(url, variable) {
    var query = url;
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
      var pair = vars[i].split("=");
      if (pair[0] == variable) { return pair[1]; }
    }
    return (false);
  }


  /**
   * 获取url参数
   * @param name 
   */
  getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
  };

  

  /**
   * 是否微信环境
   */

  isWeiXin() {
    var ua = navigator.userAgent.toLowerCase();
    if (ua.match(/MicroMessenger/i)) {
      return true
    } else {
      return false
    }
  }

}