import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetName } from "../libs/tw/enum/NetName";
import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";

export class NetPromise {
  private static instance: NetPromise;

  public static get ins(): NetPromise {
    if (!this.instance) {
      this.instance = new NetPromise();
    }
    return this.instance;
  }

  constructor() { }

  shareCode;
  inviteCode;

  Date=new Date();

  
  /**
   * 达令家养成每月赠送补签卡
   */
  times() {
    return new Promise((resolve, reject) => {
      NetManager.ins.times((success) => {
        console.log(success)
        if (!success) {
          reject(success)
        }
        resolve(success)
      })
    })
  }


  /**
   * 获取url cookie参数
   * @param url 
   * @param variable 
   */
  getQueryVariable(url, variable) {
    var query = url;
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
      var pair = vars[i].split("=");
      if (pair[0] == variable) { return pair[1]; }
    }
    return (false);
  }


  /**
   * 获取url参数
   * @param name 
   */
  getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
  };

  

  /**
   * 是否微信环境
   */

  isWeiXin() {
    var ua = navigator.userAgent.toLowerCase();
    if (ua.match(/MicroMessenger/i)) {
      return true
    } else {
      return false
    }
  }

}