import { TwFun } from './../../libs/tw/util/TwFun';
import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetName } from '../../libs/tw/enum/NetName';
import { NetPromise } from '../NetPromise';
import { NetBuried } from '../NetBuried';
export default class PrizePanel extends Panel {
    private mdata: any;

    public panelGroup: eui.Group;
    public closeBtn: eui.Button;
    public iknowBtn: eui.Button;
    public iknowRedBtn: eui.Button;
    public iknowKhBtn: eui.Button;
    public prizeNameLb: eui.Label;
    public prizeDescLab: eui.Label;
    public prizeImg: eui.Image;


    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        //joinDo:DataManager.ins.getData(NetName.joinDo).data,
        //prizeQuery:DataManager.ins.getData(NetName.prizeQuery).data
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    hideAll(){
        this.closeBtn.visible=false
        this.iknowBtn.visible=false
        this.iknowRedBtn.visible=false
        this.iknowKhBtn.visible=false
        this.prizeNameLb.visible=false
        this.prizeDescLab.visible=false
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowKhBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowRedBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        //this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowKhBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowRedBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
       // this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    private async onLoad() {
        console.log("打钩")
        var url: string = this.mdata.prizeQuery[0].icon;
        this.prizeImg.source = url;

        this.hideAll()
         //0：未中奖，1：口红1支，2：口红10支，3：红包， 4：大牌券	
        if (this.mdata.joinDo.type == 1) {
            this.iknowKhBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeDescLab.visible=true
            this.prizeNameLb.text=this.mdata.prizeQuery[0].name;
            this.prizeDescLab.text="请于24小时内领取完毕";
        }else if (this.mdata.joinDo.type == 2) {
            this.iknowKhBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeDescLab.visible=true
            this.prizeNameLb.text=this.mdata.prizeQuery[0].name
            this.prizeDescLab.text="请于24小时内领取完毕";
        }else if (this.mdata.joinDo.type == 3) {
            this.closeBtn.visible=true
            this.iknowRedBtn.visible=true
            this.prizeDescLab.visible=true
            this.prizeDescLab.text="可在活动页红包处查看所获得红包金额";
            NetBuried.ins.showLog(11)
        }else if (this.mdata.joinDo.type == 4) {
            this.closeBtn.visible=true
            this.iknowBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeNameLb.text=this.mdata.prizeQuery[0].name;
            NetBuried.ins.showLog(12)
        }
    }

    private onTap(): void {
        PanelCtrl.instance.btnDelay(this.iknowBtn);
        this.hidePanel();
        //获取游戏信息
        Loading.instace.show();
        NetManager.ins.getInfo((success: boolean) => {
            if (success) {
                if (this.mdata) {
                    this.mdata();
                }
            } else {
                //提示用户，返回上一层，重新进入活动？？？？？
                PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试！');
            }
            Loading.instace.hide();
        });
    }


    onUse() {
        //        
        //PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:10})
        PanelCtrl.instance.btnDelay(this.iknowBtn)
        PanelCtrl.instance.btnDelay(this.iknowKhBtn)
        PanelCtrl.instance.btnDelay(this.iknowRedBtn)
        this.hidePanel()
          //0：未中奖，1：口红1支，2：口红10支，3：红包， 4：大牌券	
        if (this.mdata.joinDo.type == 1) {
            PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:1})
        }else if (this.mdata.joinDo.type == 2) {
            PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:10})
        }else if (this.mdata.joinDo.type == 3) {
            NetPromise.ins.gotoIndex()
        }else if (this.mdata.joinDo.type == 4) {
            window.location.href = this.mdata.joinDo.url;
        }
    }


    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        // this.onTap();
        // 端内 活动首页
        NetPromise.ins.gotoIndex()
    }
}