import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetPromise } from '../NetPromise';
import { NetBuried } from '../NetBuried';
export default class OverPanel extends Panel {

    public panelGroup: eui.Group;
    public bg: eui.Image;
    public titleImg: eui.Image;
    public againBtn: eui.Button;
    public closeBtn: eui.Button;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'Over' }
    public get groupName() { return 'over_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        NetBuried.ins.showLog(9)
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }


    onTap_closeBtn() {
        this.onTouchTap()
        NetPromise.ins.gotoIndex()
    }

    // 重新开始游戏
    onTap_againBtn() {
        this.onTap_closeBtn()
    }


    private isMPBank() {
        var ua = navigator.userAgent;
        // var ua = 'MPBank'
        if (ua.indexOf('MPBank') > -1)
            return true;
        else
            return false;
    }
}