"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var GuidePanel_1 = require("../guidePanel/GuidePanel");
var RewardPanel = (function (_super) {
    __extends(RewardPanel, _super);
    function RewardPanel() {
        return _super.call(this) || this;
    }
    Object.defineProperty(RewardPanel.prototype, "skinKey", {
        get: function () { return 'Reward'; },
        enumerable: true,
        configurable: true
    });
    RewardPanel.prototype.start = function (data) {
        this.percentHeight = 100;
        this.updateData();
        this.guideBack = data;
        if (this.guideBack) {
            this.showGuide(9);
        }
    };
    RewardPanel.prototype.updateData = function () {
        var lottery = DataManager_1.DataManager.ins.getPlugOrderStatusData.lottery;
        this.titleTxt.text = '小海豚从' + lottery.name + '回来啦';
        this.txt.text = '给你带了张明信片，快去看看吧';
        if (lottery) {
            this.rwdImg.source = lottery.img;
        }
    };
    /**
     * 查看相册
     * @param e
     */
    RewardPanel.prototype.onClick_lookBtn = function (e) {
        var _this = this;
        if (DataManager_1.DataManager.ins.getPlugOrderStatusData.lottery && DataManager_1.DataManager.ins.getPlugOrderStatusData.lottery.type == 'collectGoods') {
            //中了集卡，那么就重新获取集卡数据，刷新集卡数量
            var mapType_1 = DataManager_1.DataManager.ins.gooutRewardData.mapType; //出游地图标识 1中国，2亚洲，3欧洲
            NetManager_1.NetManager.ins.getCollectRule(function () {
                NetManager_1.NetManager.ins.getCollectGoodsInfo(function () {
                    if (_this.guideBack) {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.ALBUM_PANEL, _this.guideBack);
                    }
                    else {
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.ALBUM_PANEL);
                    }
                }, window['collectRuleIdList'] ? window['collectRuleIdList'][mapType_1 - 1] : 1);
            }, window['collectRuleIdList'] ? window['collectRuleIdList'][mapType_1 - 1] : 1);
        }
        this.hidePanel();
    };
    RewardPanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.lookBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_lookBtn, this);
    };
    RewardPanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.lookBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_lookBtn, this);
    };
    RewardPanel.prototype.showGuide = function (index) {
        this.hideGuide();
        if (!this.guideLayer) {
            this.guideLayer = new GuidePanel_1.default();
            this.addChild(this.guideLayer);
        }
        var x;
        var y;
        var w;
        var h;
        if (index == 9) {
            x = this.lookBtn.x;
            y = this.height / 2 + this.lookBtn.verticalCenter;
            w = 422;
            h = 115;
            // }else if(index == 10){//指向关闭按钮
            //     x = this['closeBtn'].x;
            //     y = this['closeBtn'].y;
            //     w = 55;
            //     h = 55;
        }
        this.guideLayer.updateData(index, x, y, w, h);
    };
    RewardPanel.prototype.hideGuide = function () {
        if (this.guideLayer) {
            this.guideLayer.dispose();
            this.removeChild(this.guideLayer);
            this.guideLayer = null;
        }
    };
    return RewardPanel;
}(Panel_1.default));
exports.default = RewardPanel;
__reflect(RewardPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/rewardPanel/RewardPanel\".RewardPanel");
//# sourceMappingURL=RewardPanel.js.map