import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetPromise } from '../NetPromise';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { NetBuried } from '../NetBuried';
export default class TaskTipsPanel extends Panel {

    public panelGroup: eui.Group;
    public winGroup: eui.Group;
    public comGroup: eui.Group;
    public TaskTipsGroup: eui.Group;
    public gotoTaskBtn: eui.Button;
    public closeBtn: eui.Button;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'TaskTipsPanel' }
    public get groupName() { return 'tasktips_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
       // this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        NetBuried.ins.showLog(14)
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.gotoTaskBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_gotoTaskBtn,this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.gotoTaskBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_gotoTaskBtn,this)
    }

    onTap_gotoTaskBtn(){
        if(this.data.type=="bind"){
             //签约快捷支付id MB500004
             window["gotoMarket"]('快捷支付','MB500004');
        }else if(this.data.type=="mobile"){
             // 手机转账菜单id MB880001
             window["gotoMarket"]('手机转账','MB880001');
        }
    }


    onTap_closeBtn() {
        super.onTouchTap()
        //如果是关闭兑换成功弹窗，则更新红包主页的数据
        if (this.mdata.winType == "convertSuccessGroup") {
            GDispatcher.dispatchEvent("updateRedScene")
        }
    }
}