import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import TaskItem from './TaskItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import { NetBuried } from '../NetBuried';

export default class StartScene extends Scene {

    public scroller_body:eui.Scroller;
    public bg:eui.Image;
    public topBtn:eui.Group;
    public ruleBtn:eui.Button;
    public recordBtn:eui.Button;
    public disc_ico:eui.Image;
    public startBtn:eui.Button;
    public limitTodyText:eui.Label;
    public list:eui.List;
    public detailBtn:eui.Group;
    public detailText:eui.Label;
    public adList:eui.Label;
    

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        this.detailBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_detailBtn, this)
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this)
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        this.detailBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_detailBtn, this)
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this)
        clearInterval(this.adTime)
    }

    onTap_recordBtn(){
        PanelCtrl.instance.btnDelay(this.recordBtn);
        window.location.href=window["recordUrl"];
    }

    onTap_ruleBtn() {
        let ruleData = `1、活动时间：2019年11月28日-12月4日

2、活动期间，每位用户每天仅有一次挑战机会，完成“每日分享”可额外获得一次挑战次数。挑战机会当日有效，隔日作废。

3、游戏闯关后，将有机会获得口红大奖、红包等好礼，100%中奖！

4、完成“签约快捷支付功能”、“签约手机号转账”任务，有机会获得精美奖品！

5、口红大奖及大牌券等好礼的兑换方式及使用规则可至“我的奖品”中进行查看。

6、红包金额可至活动页面右侧“红包”处进行查看，红包需于活动结束后5个工作日内兑换完成。兑换的奖励于7个工作日后至民生银行App-生活圈-乐享优品-个人中心-代金券查看并使用。

7、本次活动最终解释权归中国民生银行上海分行所有。`
        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "ruleGroup", ruleData: ruleData })
    }

    onTap_detailBtn() {
        this.enabled = false;
        NetPromise.ins.detailDo()
            .then(() => {
                this.enabled = true;
                SceneCtrl.instance.change(ModuleTypes.RED_SCENE)
            })
            .catch(() => {
                this.enabled = true;
            })
    }

    onTap_startBtn() {
      //  PanelCtrl.instance.btnDelay(this.startBtn)
      this.enabled=false;
        NetBuried.ins.clickLog(2)
        if(!NetPromise.ins.not_login){
            if (window['requirelogin']) {
                window['requirelogin']();
                this.enabled=true;
                return;
            }
            this.enabled=true;
            return
        }

        if (DataManager.ins.getData(NetName.detailDo).data.endTime <= new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "overActGroup" });
            this.enabled=true;
            return;
        }

        if (DataManager.ins.getData(NetName.detailDo).data.beginTime > new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "beginActGroup" });
            this.enabled=true;
            return;
        }

        

        // if(!window["isShanghai"]){
        //     NetPromise.ins.showToast("仅上海地区用户可参与活动哦~")
        //     this.enabled=true;
        //     if(!localStorage.duibadev){
        //         return
        //     }
        // }
        
        if(DataManager.ins.getData(NetName.times).data.times<=0){
            if(DataManager.ins.getData(NetName.times).data.qualification){
                console.log("分享增加次数弹窗")
                PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"tipsShareGroup"})
            }else{
                PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"noTimesGroup"})
                console.log("次数已用完弹窗")
            }
            this.enabled=true;
            return;
        }

        NetPromise.ins.join2recordDo()
        .then(()=>{
            this.enabled=true;
            const isfirst = egret.localStorage.getItem('showGuide');
            if (!isfirst) {
                egret.localStorage.setItem('showGuide', 'true');
                PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
            } else {
                SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
            }
        })
        .catch(()=>{
            this.enabled=true;
        })
    }

    adTime

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;
        let stageHeight = 750 / window.innerWidth * window.innerHeight;
        this.scroller_body.height = stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        NetBuried.ins.showLog(1)
        NetBuried.ins.showLog(2)
       

        let i_a=0
        this.adList.text=window["adList"][i_a]
        this["adlistShow"].play(0)
        i_a++
        this.adTime=setInterval(()=>{
            this.adList.text=window["adList"][i_a]
            this["adlistShow"].play(0)
            if(i_a>=window["adList"].length-1){
                i_a=0
            }else{
                i_a++
            }
        },2250)

        this.animation()

        this.list.itemRenderer = TaskItem;
        this.list.dataProvider = new eui.ArrayCollection([])

        if(!NetPromise.ins.not_login){
            this.limitTodyText.text=`请先完成登陆`
            let _data= [
                {
                    "type":"share",
                    "status":0
                },
                {
                    "type":"bind",
                    "status":0
                },
                {
                    "type":"mobile",
                    "status":0
                }
            ]
            this.list.dataProvider = new eui.ArrayCollection(_data)
            return
        }

        this.limitTodyText.text=`今天剩余次数:${DataManager.ins.getData(NetName.times).data.times}次`

        
        NetPromise.ins.listDo()
            .then(() => {
                this.list.dataProvider = new eui.ArrayCollection(DataManager.ins.getData(NetName.listDo).data)
            })
            .catch(() => {
                
            })

        NetPromise.ins.detailDo()
            .then(() => {
                let year = new Date(DataManager.ins.getData(NetName.detailDo).data.endTime).getUTCFullYear()
                let month = new Date(DataManager.ins.getData(NetName.detailDo).data.endTime).getUTCMonth()
                let day = new Date(DataManager.ins.getData(NetName.detailDo).data.endTime).getUTCDate()

                let yearNow = new Date().getUTCFullYear()
                let monthNow = new Date().getUTCMonth()
                let dayNow = new Date().getUTCDate()

                this.detailText.text = DataManager.ins.getData(NetName.detailDo).data.total.toFixed(2);
                if (DataManager.ins.getData(NetName.detailDo).data.endTime <= new Date()) {
                    if (!localStorage.overActGroup) {
                        localStorage.overActGroup = 1;
                        //活动已结束弹窗
                        console.log("活动已结束弹窗")
                        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "overActGroup" });
                    }
                } else if (year == yearNow && month == monthNow && dayNow - day == 0) {
                    if (!localStorage.lastDayGroup) {
                        localStorage.lastDayGroup = 1;
                        //活动最后一天弹窗
                        console.log("活动最后一天弹窗")
                        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "lastDayGroup" });
                    }
                }
            })
            .catch(() => { })

    }

    animation() {
        this["disc_loop"].play(0)
        this["disc_loop"].items.forEach((item) => {
            item.tween.loop = true;
        })
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {

    }
    private canStart: boolean;

}