import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import KhItem from './KhItem';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
export default class SelectKhPanel extends Panel {

    public panelGroup: eui.Group;
    public closeBtn: eui.Button;
    public sureBtn: eui.Button;
    public bodyScroller: eui.Scroller;
    public list: eui.List;


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'SelectKhPanel' }
    public get groupName() { return 'selectkh_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }

    khData

    arrData

    onSkinComplete(): void {
        super.onSkinComplete();

        console.log(window["kh_data"])

        var tlayout = new eui.TileLayout();
        tlayout.horizontalGap = 0;
        tlayout.verticalGap = 0;
        tlayout.requestedColumnCount = 3;
        this.list.layout = tlayout;

        this.khData = window["kh_data"]
        for (let i = 0; i < this.khData.length; i++) {
            this.khData[i].select = false;
            this.khData[i].index = i;
        }
        this.list.itemRenderer = KhItem;
        this.arrData=new eui.ArrayCollection(this.khData);
        this.list.dataProvider =  this.arrData;
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        GDispatcher.addEvent("updateKhList", this.updateKhList, this)
    }

    catchY = 0

    updateKhList(index, select) {
        this.catchY = this.bodyScroller.viewport.scrollV
        console.log( "this.catchY ")
        console.log( this.catchY )
        this.khData[index].select = select;
        this.arrData.replaceAll(this.khData);
    }

    removeEvents(): void {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        GDispatcher.removeEvent("updateKhList", this.updateKhList, this)
    }


    onTap_closeBtn() {
        this.onTouchTap()
    }
}