import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetPromise } from '../NetPromise';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { NetBuried } from '../NetBuried';
export default class PubPanel extends Panel {

    public panelGroup:eui.Group;
    public lightGroup:eui.Group;
    public winGroupHasTitle:eui.Group;
    public gift_ico:eui.Image;
    public winGroupNoneTitle:eui.Group;
    public comGroup:eui.Group;
    public convertSuccessGroup:eui.Group;
    public closeConvertBtn:eui.Button;
    public lastDayGroup:eui.Group;
    public closelastDayBtn:eui.Button;
    public overActGroup:eui.Group;
    public closeoverActBtn:eui.Button;
    public beginActGroup:eui.Group;
    public beginText:eui.Label;
    public closebeiginActBtn:eui.Button;
    public ruleGroup:eui.Group;
    public ruleText:eui.Label;
    public convertSureGroup:eui.Group;
    public convertSureText:eui.Label;
    public convertSureBtn:eui.Button;
    public tipsShareGroup:eui.Group;
    public shareTaskBtn:eui.Button;
    public noTimesGroup:eui.Group;
    public noTimesSureBtn:eui.Button;
    public closeBtn:eui.Button;
    
    
    


    private mdata: any;
    private scene: any;

    public get skinKey() { return 'PubPanel' }
    public get groupName() { return 'pub_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
        this.scene = data.scene;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.winGroupNoneTitle.visible = false;
        this.lightGroup.visible = false;
        this.winGroupHasTitle.visible = false;
        this.gift_ico.visible = false;
        this.convertSuccessGroup.visible = false;
        this.convertSureGroup.visible = false;
        this.ruleGroup.visible = false;
        this.overActGroup.visible = false;
        this.lastDayGroup.visible = false;
        this.tipsShareGroup.visible = false;
        this.noTimesGroup.visible = false;
        this.beginActGroup.visible = false;

        if (this.mdata.winType == "convertSuccessGroup") {
            this.lightGroup.visible = true;
            this.convertSuccessGroup.visible = true;
            this.winGroupHasTitle.visible = true;
            this.gift_ico.visible = true;
            NetBuried.ins.showLog(16)
        } else if (this.mdata.winType == "convertSureGroup") {
            this.convertSureGroup.visible = true;
            this.winGroupNoneTitle.visible = true;
            this.convertSureText.text = `您可兑换金额为\n${this.mdata.voucher}元的代金券`;
        } else if (this.mdata.winType == "ruleGroup") {
            this.ruleGroup.visible = true;
            this.winGroupHasTitle.visible = true;
            this.ruleText.text = this.mdata.ruleData;
        } else if (this.mdata.winType == "overActGroup") {
            this.lightGroup.visible = true;
            this.overActGroup.visible = true;
            this.winGroupHasTitle.visible = true;
        } else if (this.mdata.winType == "beginActGroup") {
            this.lightGroup.visible = true;
            this.beginActGroup.visible = true;
            this.winGroupHasTitle.visible = true;
            this.beginText.text=`活动将于\n${new Date().getUTCFullYear()}年${new Date().getUTCMonth()+1}月${new Date().getUTCDate()}日XXX点正式开始`
        } else if (this.mdata.winType == "lastDayGroup") {
            this.lightGroup.visible = true;
            this.lastDayGroup.visible = true;
            this.winGroupHasTitle.visible = true;
        } else if (this.mdata.winType == "tipsShareGroup" || this.mdata.winType == "noTimesGroup") {
            this.winGroupNoneTitle.visible = true;
            this[this.mdata.winType].visible=true
            if(this.mdata.winType == "tipsShareGroup"){
                NetBuried.ins.showLog(10)
            }

            if(this.mdata.winType == "noTimesGroup"){
                NetBuried.ins.showLog(13)
            }
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.convertSureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_convertSureBtn, this);
        this.closeConvertBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeConvertBtn, this);
       // this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closelastDayBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closeoverActBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closebeiginActBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        //执行分享任务按钮
        this.shareTaskBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareTaskBtn, this);
        //今天没有游戏次数
        this.noTimesSureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_noTimesSureBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.convertSureBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_convertSureBtn, this);
        this.closeConvertBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeConvertBtn, this);
      //  this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closebeiginActBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closeoverActBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        this.closelastDayBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
        //执行分享任务按钮
        this.shareTaskBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareTaskBtn, this);
        //今天没有游戏次数
        this.noTimesSureBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_noTimesSureBtn, this);
    }


    //执行分享任务
    onTap_shareTaskBtn(){
        NetPromise.ins.doShare()
    }

    //今天没有游戏次数
    onTap_noTimesSureBtn(){
        this.onTouchTap()
    }

    onTouchTap(){
        super.onTouchTap()
        if(this.mdata.gotoIndex){
            NetPromise.ins.gotoIndex()
        }
    }

    //红包页面-确认兑换弹窗-确认兑换优惠券
    onTap_convertSureBtn() {
        NetPromise.ins.join3joinDo()
            .then((e) => {
                this.onTap_closeBtn()
                PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "convertSuccessGroup" })
            })
            .catch((e) => {
                this.onTap_closeBtn()
                console.error(e)
                console.log("兑换失败")
            })
    }

    //红包页面-优惠券兑换成功弹窗-立即收下按钮
    onTap_closeConvertBtn() {
        this.onTap_closeBtn()
    }

    onTap_closeBtn() {
        super.onTouchTap()
        //如果是关闭兑换成功弹窗，则更新红包主页的数据
        if (this.mdata.winType == "convertSuccessGroup") {
            GDispatcher.dispatchEvent("updateRedScene")
        }
    }
}