import ComponentBase from "../components/ComponentBase";
import Loading from "../loading/Loading";

export default class Panel extends ComponentBase {
    protected panelGroup: eui.Group;
    public pMask: egret.Shape;
    private hasMask: boolean;
    constructor(data?, hasMask: boolean = true) {
        super(data);
        this.hasMask = hasMask;
    }

    /**
     * 
     * @param hasColor true 有颜色  false为没有颜色
     */
    setMask(): void {
        if (!this.pMask) {
            var rate: number = document.body.clientHeight / document.body.clientWidth;
            this.pMask = new egret.Shape();
            this.pMask.graphics.beginFill(0, 0.8);
            this.pMask.graphics.drawRect(0, 0, 750, 1624);//750 * rate);
            this.pMask.graphics.endFill();
            this.addChildAt(this.pMask, 0);

            this.pMask.touchEnabled = false;
        }

    }

    setShowAct(): void {
        this.alpha = 0;
        // this.y = document.body.clientHeight;
        // this.scaleY = 0;
        egret.Tween.get(this).to({ alpha: 1 }, 300);
    }

    initEvents() {
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(
                btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(
                btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        // if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
        //     this.creditsOutBtns.forEach(
        //         btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
        //     )
        // }

    }
    removeEvents() {
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(
                btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(
                btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }

        // if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
        //     this.creditsOutBtns.forEach(
        //         btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
        //     )
        // }
    }

    protected onSkinComplete() {
        super.onSkinComplete();
        Loading.instace.hide();


        this.setMask();
        if (!this.hasMask) {
            this.pMask.alpha = 0;
        }

        this.setShowAct();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    protected get confirmBtns(): eui.Button[] { return [this['confirmBtn']] }
    // protected get creditsOutBtns(): eui.Button[] { return [this['creditsOutBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    //播放显示动画
    showAct(callback: Function = null): void {
        if (this.panelGroup) {
            this.panelGroup.touchEnabled = false;
            this.panelGroup.touchChildren = false;

            this.panelGroup.scaleX = 0;
            this.panelGroup.scaleY = 0;

            var aX: number = this.panelGroup.width * 0.5;
            var aY: number = this.panelGroup.height * 0.5;

            this.panelGroup.anchorOffsetX = aX;
            this.panelGroup.anchorOffsetY = aY;

            this.panelGroup.x += aX;
            this.panelGroup.y += aY;

            egret.Tween.get(this.panelGroup).to({ scaleX: 1, scaleY: 1 }, 300, egret.Ease.backInOut).call(function () {
                if (callback) {
                    callback();
                }
                this.panelGroup.touchEnabled = true;
                this.panelGroup.touchChildren = true;
            }.bind(this));
        }
    }

    hidePanel() {
        egret.Tween.get(this.panelGroup).to({ alpha: 0 }, 0, egret.Ease.sineOut).call(function () {
            this.destroy();
            this.dispatchEvent(new egret.Event('onDestroy'));
        }.bind(this));

    }

    clearEvent() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }

    creditsOut() {
        this.destroy();
        // this.dispatchEvent(new egret.Event('onCreditsOut'));
    }

}