import { GameGetSubmitResultData } from '../../libs/tw/data/game/submit/GameGetSubmitResultData';
import { GetInfoData } from '../../libs/tw/data/game/getInfo/GetInfoData';
import Panel from "../views/Panel";
import MItem from '../components/MItem';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { NetPromise } from '../NetPromise';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetName } from '../../libs/tw/enum/NetName';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { NetBuried } from '../NetBuried';

export default class TaskItem extends MItem {

    public btn_0:eui.Button;
    public btn_1:eui.Button;
    public btn_2:eui.Button;
    public btn_3:eui.Button;
    public title:eui.Label;
    public tips:eui.Label;
    public desc:eui.Label;
    public listIco:eui.Image;
    
    constructor() {
        super();
    }
   
    dataChanged(){

        this.btn_0.visible=false;
        this.btn_1.visible=false;
        this.btn_2.visible=false;
        this.btn_3.visible=false;

        
        if(this["btn_"+this.data.status]){
            this["btn_"+this.data.status].visible=true;
        }
        
        if(this.data.type=="share"){
            this.title.text="每日分享"
            this.desc.text="可额外获得一次游戏次数"
        }else if(this.data.type=="bind"){
            this.title.text="签约快捷支付功能"
            this.desc.text="有机会获得精美奖品"
        }else if(this.data.type=="mobile"){
            this.title.text="签约手机号转账"
            this.desc.text="有机会获得精美奖品"
        }
       
    }

    onSkinComplete(){
        //去完成按钮
        this.btn_0.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_0,this)
        this.btn_1.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_1,this)
        this.btn_2.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_2,this)
        this.btn_3.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_btn_3,this)

        console.log(this.data)

        if(this.data.type=="share"){
            if(this.data.status==0){
                NetBuried.ins.showLog(3)
            }
        }else if(this.data.type=="bind"){
            if(this.data.status==0){
                NetBuried.ins.showLog(4)
            }else if(this.data.status==2){
                NetBuried.ins.showLog(6)
            }
        }else if(this.data.type=="mobile"){
            if(this.data.status==0){
                NetBuried.ins.showLog(5)
            }else if(this.data.status==2){
                NetBuried.ins.showLog(7)
            }
        }
    }
   

    //去完成
    onTap_btn_0(){

        PanelCtrl.instance.btnDelay(this.btn_0)

        if (DataManager.ins.getData(NetName.detailDo).data.endTime <= new Date()) {
            PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "overActGroup" });
            return;
        }
       
        if(this.data.type=="share"){
            if(this.data.status==0){
                NetBuried.ins.clickLog(3)
            }
            NetPromise.ins.doShare()
        }else if(this.data.type=="bind"){
            if(this.data.status==0){
                NetBuried.ins.clickLog(4)
            }else if(this.data.status==2){
                NetBuried.ins.clickLog(6)
            }
            //window.location.href=window["bindUrl"];
            PanelCtrl.instance.show(ModuleTypes.TASKTIPS_PANEL,{type:this.data.type})
        }else if(this.data.type=="mobile"){
            if(this.data.status==0){
                NetBuried.ins.clickLog(5)
            }else if(this.data.status==2){
                NetBuried.ins.clickLog(7)
            }
            PanelCtrl.instance.show(ModuleTypes.TASKTIPS_PANEL,{type:this.data.type})
            //window.location.href=window["mobileUrl"];
        }
    }
    //待发奖
    onTap_btn_1(){

    }
    //待领奖
    onTap_btn_2(){
        PanelCtrl.instance.btnDelay(this.btn_2)
        NetPromise.ins.join1joinDo(this.data.type)
        .then(()=>{
            if(DataManager.ins.getData(NetName.join1joinDo).data.prizeId){
                return NetPromise.ins.prizeQuery(DataManager.ins.getData(NetName.join1joinDo).data.prizeId)
            }else{
                this.showPrizePanel();
            }
        })
        .then(()=>{
            this.showPrizePanel();
        })
        .catch(()=>{
            this.showPrizePanel();
        })
    }

    private showPrizePanel(): void {
        //处理中奖情况
        if (DataManager.ins.getData(NetName.join1joinDo).data.type!=0) {//中奖了
            PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL, {joinDo:DataManager.ins.getData(NetName.join1joinDo).data,prizeQuery:DataManager.ins.getData(NetName.prizeQuery).data});
        } else {
            //未中奖,（必中活动未中奖要做容错处理）
            let data = { scene: this };
            PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL, data);
        }
    }
    //已完成
    onTap_btn_3(){

    }
}