import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import TaskItem from './TaskItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';

export default class StartScene extends Scene {

    public scroller_body:eui.Scroller;
    public bg:eui.Image;
    public topBtn:eui.Group;
    public ruleBtn:eui.Button;
    public recordBtn:eui.Button;
    public disc_ico:eui.Image;
    public startBtn:eui.Button;
    public limitTodyText:eui.Label;
    public list:eui.List;
    public detailBtn:eui.Group;
    public detailText:eui.Label;
    public adList:eui.Label;
    


    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        this.detailBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_detailBtn, this)
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this)
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this)
        this.detailBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_detailBtn, this)
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this)
        this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this)
        clearInterval(this.adTime)
    }

    onTap_recordBtn(){
        PanelCtrl.instance.btnDelay(this.recordBtn);
        window.location.href=window["recordUrl"];
    }

    onTap_ruleBtn() {
        let ruleData = `规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则
规则规则规则规则规则规则规则规则规则
        `
        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "ruleGroup", ruleData: ruleData })
    }

    onTap_detailBtn() {
        this.enabled = false;
        NetPromise.ins.detailDo()
            .then(() => {
                this.enabled = true;
                SceneCtrl.instance.change(ModuleTypes.RED_SCENE)
            })
            .catch(() => {
                this.enabled = true;
            })
    }

    onTap_startBtn() {


        if(!NetPromise.ins.not_login){
            alert("唤起登陆方法")
        }

        if(!NetPromise.ins.isShanghai){
            NetPromise.ins.showToast("仅上海地区用户可参与活动哦~")
            if(!localStorage.duibadev){
                return
            }
        }
        
        if(DataManager.ins.getData(NetName.times).data.times<=0){
            if(DataManager.ins.getData(NetName.times).data.qualification){
                console.log("分享增加次数弹窗")
                PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"tipsShareGroup"})
            }else{
                PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"noTimesGroup"})
                console.log("次数已用完弹窗")
            }
            return;
        }

        NetPromise.ins.join2recordDo()
        .then(()=>{
            const isfirst = egret.localStorage.getItem('showGuide');
            if (!isfirst) {
                egret.localStorage.setItem('showGuide', 'true');
                PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
            } else {
                SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
            }
        })
        .catch(()=>{})
    }

    adTime

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;
        let stageHeight = 750 / window.innerWidth * window.innerHeight;
        this.scroller_body.height = stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        let i_a=0

        this.adTime=setInterval(()=>{
            this.adList.text=window["adList"][i_a]
            this["adlistShow"].play(0)
            if(i_a>=window["adList"].length-1){
                i_a=0
            }else{
                i_a++
            }
        },2250)

        this.animation()

        this.limitTodyText.text=`今天剩余次数:${DataManager.ins.getData(NetName.times).data.times}次`

        this.list.itemRenderer = TaskItem;
        NetPromise.ins.listDo()
            .then(() => {
                this.list.dataProvider = new eui.ArrayCollection(DataManager.ins.getData(NetName.listDo).data)
            })
            .catch(() => {

            })

        NetPromise.ins.detailDo()
            .then(() => {
                let year = new Date(DataManager.ins.getData(NetName.detailDo).data.endTime).getUTCFullYear()
                let month = new Date(DataManager.ins.getData(NetName.detailDo).data.endTime).getUTCMonth()
                let day = new Date(DataManager.ins.getData(NetName.detailDo).data.endTime).getUTCDate()

                let yearNow = new Date().getUTCFullYear()
                let monthNow = new Date().getUTCMonth()
                let dayNow = new Date().getUTCDate()

                this.detailText.text = DataManager.ins.getData(NetName.detailDo).data.total.toFixed(2);
                if (DataManager.ins.getData(NetName.detailDo).data.endTime <= new Date()) {
                    if (!localStorage.overActGroup) {
                        localStorage.overActGroup = 1;
                        //活动已结束弹窗
                        console.log("活动已结束弹窗")
                        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "overActGroup" });
                    }
                } else if (year == yearNow && month == monthNow && dayNow - day == 0) {
                    if (!localStorage.lastDayGroup) {
                        localStorage.lastDayGroup = 1;
                        //活动最后一天弹窗
                        console.log("活动最后一天弹窗")
                        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL, { winType: "lastDayGroup" });
                    }
                }
            })
            .catch(() => { })

    }

    animation() {
        this["disc_loop"].play(0)
        this["disc_loop"].items.forEach((item) => {
            item.tween.loop = true;
        })
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {

    }
    private canStart: boolean;

}