import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import TaskItem from './TaskItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';

export default class StartScene extends Scene {
   
    public scroller_body:eui.Scroller;
    public bg:eui.Image;
    public topBtn:eui.Group;
    public disc_ico:eui.Image;
    public startBtn:eui.Button;
    public list:eui.List;
    public detailBtn:eui.Group;
    public detailText:eui.Label;
    
    

    
    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_startBtn,this)
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_startBtn,this)
    }

    onTap_startBtn(){
        const isfirst = egret.localStorage.getItem('showGuide');
        if (!isfirst) {
            egret.localStorage.setItem('showGuide', 'true');
            PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
        } else {
            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE)
        }
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;
        let stageHeight=750/window.innerWidth*window.innerHeight;
        this.scroller_body.height=stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.animation()

        this.list.itemRenderer=TaskItem;
        NetPromise.ins.listDo()
        .then(()=>{
            this.list.dataProvider=new eui.ArrayCollection(DataManager.ins.getData(NetName.listDo).data)
        })
        .catch(()=>{

        })

        NetPromise.ins.detailDo()
        .then(()=>{
            this.detailText.text=DataManager.ins.getData(NetName.detailDo).data.total.toFexid(2)
        })
        .catch(()=>{})

    }

    animation(){
        this["disc_loop"].play(0)
        this["disc_loop"].items.forEach((item)=>{
            item.tween.loop=true;
        })
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
      
    }
    private canStart: boolean;

}