import { GameGetSubmitResultData } from '../../libs/tw/data/game/submit/GameGetSubmitResultData';
import { GetInfoData } from '../../libs/tw/data/game/getInfo/GetInfoData';
import Panel from "../views/Panel";
import MItem from '../components/MItem';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { NetPromise } from '../NetPromise';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetName } from '../../libs/tw/enum/NetName';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { NetBuried } from '../NetBuried';

export default class KhItem extends MItem {

    public khText:eui.Label;
    public pic_ico:eui.Image;
    public pic_selected:eui.Image;
    public btn:eui.Group;

    

    constructor() {
        super();
    }
   
    dataChanged(){
        console.log("this.data")
        console.log(this.data)
        this.pic_selected.visible=false;
        this.pic_ico.source=this.data.pic;
        this.khText.text=this.data.name;
       if(this.data.select){
          this.pic_selected.visible=true;
       }
    }

    onSkinComplete(){
        //去完成按钮
        this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP,()=>{
            GDispatcher.dispatchEvent("updateKhList",this.data.index,!this.data.select)
        },this)
    }
}