import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { GamePlayModel } from './../../libs/tw/model/game/GamePlayModel';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import SceneCtrl from '../ctrls/sceneCtrl';
import RedItem from './RedItem';
import { NetPromise } from '../NetPromise';
import { NetName } from '../../libs/tw/enum/NetName';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';

export default class RedScene extends Scene {

    public scroller_body: eui.Scroller;
    public bg: eui.Image;
    public totalText: eui.Label;
    public voucherText: eui.Label;
    public redTipsText: eui.Label;
    public list: eui.List;
    public convertBtn: eui.Button;
    public backBtn: eui.Button;



    public get skinKey() { return 'RedScene' }
    public get groupName() { return 'red_scene' }

    constructor(data?) {
        super(data);
        this.data = DataManager.ins.getData(NetName.detailDo).data;
    }

    initEvents() {
        super.initEvents();
        this.convertBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_convertBtn, this)
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this)
        GDispatcher.addEvent("updateRedScene",this.updateData,this)
    }

    removeEvents() {
        super.removeEvents();
        this.convertBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_convertBtn, this)
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this)
        GDispatcher.removeEvent("updateRedScene",this.updateData,this)
    }

    onTap_backBtn(){
        this.enabled=false;
        NetPromise.ins.timesDo()
        .then((e)=>{
            this.enabled=true;
            console.log(e)
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
        .catch((e)=>{
            this.enabled=true;
            PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试');
        })
    }

    onTap_convertBtn() {
        PanelCtrl.instance.btnDelay(this.convertBtn);
        PanelCtrl.instance.show(ModuleTypes.PUB_PANEL,{winType:"convertSureGroup",voucher:this.data.voucher})
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;
        let stageHeight = 750 / window.innerWidth * window.innerHeight;
        this.scroller_body.height = stageHeight;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.animation()
        this.updateData()
    }


    updateDataNet(){
        NetPromise.ins.detailDo()
        .then(()=>{
            this.updateData()
        })
        .catch(()=>{
        })
    }

    updateData(){
        this.totalText.text = this.data.total.toFixed(2);
        if(this.data.voucher){
            this.voucherText.text = `预计可兑换代金券金额为${this.data.voucher}元`;
        }else{
            this.voucherText.text = ``;
        }
        
        this.list.itemRenderer = RedItem;
        this.list.dataProvider = new eui.ArrayCollection(this.data.details);

        if(this.data.status==0){
             //活动进行中
             this.convertBtn.enabled = false;
             this.redTipsText.text = "红包将于活动结束后统一兑换\n请于活动结束后5个工作日内兑换完成"
        }else if(this.data.status==1){
            //活动已结束
            this.convertBtn.enabled = true;
            this.redTipsText.text = "兑换后奖品将在活动结束后\n10个工作日内充值至相关账户"
        }else if(this.data.status==2){
            //活动已结束
            this.convertBtn.enabled = false;
            this.redTipsText.text = "兑换后奖品将在活动结束后\n10个工作日内充值至相关账户"
        }
    }

    animation() {
        /*  this["disc_loop"].play(0)
         this["disc_loop"].items.forEach((item)=>{
             item.tween.loop=true;
         }) */
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    timer

    start(data?) {
        super.start(data);
        this.timer = new egret.Timer(1000);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {

    }
    private canStart: boolean;

}