import { TwFun } from './../../libs/tw/util/TwFun';
import { Buried } from './../../libs/tw/util/Buried';
import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetName } from '../../libs/tw/enum/NetName';
import { NetPromise } from '../NetPromise';
export default class PrizePanel extends Panel {
    private mdata: any;

    public panelGroup: eui.Group;
    public closeBtn: eui.Button;
    public iknowBtn: eui.Button;
    public iknowRedBtn: eui.Button;
    public iknowKhBtn: eui.Button;
    public prizeNameLb: eui.Label;
    public prizeDescLab: eui.Label;
    public prizeImg: eui.Image;


    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();

       
        //立即领取埋点
        let useDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let useDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let useExposure = Buried.createExposure(useDpmOut, useDcmOut);

        NetManager.ins.showLog(useExposure);
    }

    hideAll(){
        this.closeBtn.visible=false
        this.iknowBtn.visible=false
        this.iknowRedBtn.visible=false
        this.iknowKhBtn.visible=false
        this.prizeNameLb.visible=false
        this.prizeDescLab.visible=false
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowKhBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowRedBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        //this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowKhBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.iknowRedBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
       // this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    private async onLoad() {
        console.log("打钩")
        var url: string = DataManager.ins.getData(NetName.prizeQuery).data[0].icon;
        this.prizeImg.source = url;

        this.hideAll()
         //0：未中奖，1：口红1支，2：口红10支，3：红包， 4：大牌券	
        if (DataManager.ins.getData(NetName.joinDo).data.type == 1) {
            this.iknowKhBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeDescLab.visible=true
            this.prizeNameLb.text=DataManager.ins.getData(NetName.prizeQuery).data[0].name;
            this.prizeDescLab.text="请于24小时内领取完毕";
        }else if (DataManager.ins.getData(NetName.joinDo).data.type == 2) {
            this.iknowKhBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeDescLab.visible=true
            this.prizeNameLb.text=DataManager.ins.getData(NetName.prizeQuery).data[0].name
            this.prizeDescLab.text="请于24小时内领取完毕";
        }else if (DataManager.ins.getData(NetName.joinDo).data.type == 3) {
            this.iknowRedBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeDescLab.visible=true
            this.prizeNameLb.text=DataManager.ins.getData(NetName.prizeQuery).data[0].name;
            this.prizeDescLab.text="可在活动页红包处查看所获得红包金额";
        }else if (DataManager.ins.getData(NetName.joinDo).data.type == 4) {
            this.iknowBtn.visible=true
            this.prizeNameLb.visible=true
            this.prizeNameLb.text=DataManager.ins.getData(NetName.prizeQuery).data[0].name;
        }
    }

    private onTap(): void {
        PanelCtrl.instance.btnDelay(this.iknowBtn);
        this.hidePanel();
        //获取游戏信息
        Loading.instace.show();
        NetManager.ins.getInfo((success: boolean) => {
            if (success) {
                if (this.mdata) {
                    this.mdata();
                }
            } else {
                //提示用户，返回上一层，重新进入活动？？？？？
                PanelCtrl.instance.showMsg('okBtn', 4, null, null, null, null, '请刷新重试！');
            }
            Loading.instace.hide();
        });
    }


    onUse() {
        //        
        //PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:10})
        PanelCtrl.instance.btnDelay(this.iknowBtn)
        PanelCtrl.instance.btnDelay(this.iknowKhBtn)
        PanelCtrl.instance.btnDelay(this.iknowRedBtn)
        this.onTouchTap()
          //0：未中奖，1：口红1支，2：口红10支，3：红包， 4：大牌券	
        if (DataManager.ins.getData(NetName.joinDo).data.type == 1) {
            PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:1})
        }else if (DataManager.ins.getData(NetName.joinDo).data.type == 2) {
            PanelCtrl.instance.show(ModuleTypes.SELECTKH_PANEL,{maxSelect:10})
        }else if (DataManager.ins.getData(NetName.joinDo).data.type == 3) {
            NetPromise.ins.gotoIndex()
            //window.location.href = DataManager.ins.getData(NetName.joinDo).data.url;
        }else if (DataManager.ins.getData(NetName.joinDo).data.type == 4) {
            window.location.href = DataManager.ins.getData(NetName.joinDo).data.url;
        }
    }


    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        // this.onTap();
        // 端内 活动首页
        NetPromise.ins.gotoIndex()
    }
}