'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api/index.js';
import 'spark-design/dist/index.css'
import { Toast, getModalHoc } from '../../../node_modules/spark-design';
import './pagemainscene.less';
import ruleModal from '../../components/comrulep/comrulep.jsx';
import rankModal from '../../components/comrankp/comrankp.jsx';
import rankPrizeModal from '../../components/comawardp/comawardp.jsx';
import exchangeModal from '../../components/comexp/comexp.jsx';
import inviteRcordModal from '../../components/cominvitep/cominvitep.jsx';
import { getPxToken } from '../../libs/spark_gettoken';
import { MODAL_MAP } from '../../constant';
const RuleModal = getModalHoc(ruleModal);
const RankModal = getModalHoc(rankModal);
const RankPrizeModal = getModalHoc(rankPrizeModal);
const ExchangeModal = getModalHoc(exchangeModal);
const InviteRcordModal = getModalHoc(inviteRcordModal);
class Pagemainscene extends Component {
  dataStore = {};
  inviteNum = 0;
  noinviteList = []
  constructor(props) {
    super(props);
    // this.state = this.state || { resList: resList };
    this.state = {
      resList: resList,
      nickname: "",
      avatar: "",
      energy: 0,
      yesterdayStepCount: 0,
      myscore: 0,
      myindex: "1000+",
      modalState: 0,
      rule: "",
      taskList: [{
        "taskName": "",
        "taskId": 1,
        "taskTotalCount": 0,
        "taskFinishCount": 0,
        "taskBonus": 0,
        "icon": "",
        "url": "",
        "finish": false
      },
      {
        "taskName": "",
        "taskId": 1,
        "taskTotalCount": 0,
        "taskFinishCount": 0,
        "taskBonus": 0,
        "icon": "",
        "url": "",
        "finish": false
      }, {
        "taskName": "",
        "taskId": 1,
        "taskTotalCount": 0,
        "taskFinishCount": 0,
        "taskBonus": 0,
        "icon": "",
        "url": "",
        "finish": false
      }],
      rankList: [],//排行榜信息
      inviteList: [],
      goodlist: [],
      shareMask: false,
      rankPrizeInfo: {},
      inviteRecordList: [],//邀请记录
      exchangeGoodsList: [],//兑换商品列表
      chooseGoodsInfo: {}
    }
  }
  componentDidMount() {
    this.getIndexInfo()
    this.getMyrankInfo()
    this.getInviteList()
    this.getExchangeList()
    this.showRankPrizeModal();
    this.getExchangeGoods();
  }
  async getIndexInfo() {
    this.dataStore.indexinfo = await API.index()
    if (!this.dataStore.indexinfo.success) {
      // this.hideWaitting()
      Toast(this.dataStore.indexinfo.message)
      return
    }
    let { nickname, avatar, energy, yesterdayStepCount, tasks } = this.dataStore.indexinfo.data
    this.setState({
      nickname: nickname,
      avatar: avatar,
      energy: energy,
      yesterdayStepCount: yesterdayStepCount,
      taskList: tasks
    })
  }
  async getMyrankInfo() {
    this.dataStore.myrank = await API.myrank()
    if (!this.dataStore.myrank.success) {
      Toast(this.dataStore.myrank.message)
      return
    }
    this.setState({
      myscore: this.dataStore.myrank.data.score,
      myindex: this.dataStore.myrank.data.index
    })

  }
  goFinishTask(index, taskId) {
    getPxToken(async token => {
      const res = await API.completeTask({ token: token, taskId: taskId });
      if (res.success) {
        let taskList = this.dataStore.indexinfo.data.tasks
        //签到任务
        this.getIndexInfo();
        if (taskList[index].url) {
          window.location.href = taskList[index].url
        }
      } else {
        Toast(res.message)
        return;
      }
    })

  }
  //获取邀请列表
  async getInviteList() {
    this.dataStore.inviteList = await API.inviteList();
    if (!this.dataStore.inviteList.success) {
      Toast(this.dataStore.inviteList.message);
      return
    }
    let { data } = this.dataStore.inviteList
    this.inviteNum = data.length;
    if (this.inviteNum < 10) {
      for (let i = this.inviteNum; i < 10; i++) {
        this.noinviteList.push(i);
      }
      console.log(this.noinviteList)
    }
    this.setState({
      inviteList: data
    })

  }

  inviteShare() {
    //调用分享方法 出分享蒙层。。。
    console.info("调用分享")
    this.setState({
      shareMask: true
    })
  }
  closeShare() {
    //调用分享方法 出分享蒙层。。。
    console.info("关闭蒙层")
    this.setState({
      shareMask: false
    })
  }

  //获取兑换列表
  async getExchangeList() {
    this.dataStore.exchangeList = await API.exchangeList();
    let goodsDataList = [
      { prizeName: "商品1", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      { prizeName: "商品2", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      { prizeName: "商品3", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品4", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品5", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品6", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品7", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
    ];
    console.log('{{{{{{{{{{{{', this.dataStore.exchangeList);
    if (!this.dataStore.exchangeList.success) {
      Toast(this.dataStore.message);
      if (!this.dataStore.code) {
        this.setState({
          goodlist: goodsDataList
        });
      }
      return;
    }
    this.setState({
      goodlist: this.dataStore.exchangeList.data
    })
    console.info(this.dataStore.exchangeList.data)
    console.info(this.state.goodlist)
  }

  /**
   * LS20201030
   * 控制弹窗
   * @param {*} type 
   */
  modalControl(type) {
    this.setState({
      modalState: MODAL_MAP[type]
    })
  }
  /**
   * LS20201030
   * 获取规则信息
   */
  async showRule() {
    this.modalControl('rule');
    let { data } = await API.getRule();
    console.log('data===', data);
    this.setState({
      rule: data
    })
    console.log('+++++++', this.state.modalState);
  }
  /**
   * LS20201030
   * 获取排行榜信息
    myrank//我的排行榜名次
    rankList,//排行榜列表 
    avatar: ""
    index: 10
    nickname: "ullamco"
    score: 12112
    userId: "121211111"
   */
  async showRank() {
    this.modalControl("rankInfo");
    let rankListData = await API.rankList();
    // let myRankData = await API.myrank();
    let myRankData = this.dataStore.myrank;
    console.log('rankListData=', rankListData);
    console.log('myRankData=', myRankData);
    if (rankListData.success && rankListData.data) {
      console.log('给排行榜信息赋值');

    } else {
      this.setState({
        rankList: [
          {
            avatar: "",
            index: 1,
            nickname: "name1231",
            score: 111,
            userId: "11111"
          },
          {
            avatar: "",
            index: 2,
            nickname: "name31231232大叔大",
            score: 222,
            userId: "22222"
          },
          {
            avatar: "",
            index: 3,
            nickname: "nam443",
            score: 333,
            userId: "33333"
          },
          {
            avatar: "",
            index: 4,
            nickname: "n",
            score: 333,
            userId: "33333"
          },
          {
            avatar: "",
            index: 5,
            nickname: "nam4e3",
            score: 333,
            userId: "33333"
          },
          {
            avatar: "",
            index: 6,
            nickname: "na4324234234me3",
            score: 333,
            userId: "33333"
          },
          {
            avatar: "",
            index: 7,
            nickname: "name3",
            score: 333,
            userId: "33333"
          },
          {
            avatar: "",
            index: 8,
            nickname: "name3",
            score: 333,
            userId: "33333"
          },
          {
            avatar: "",
            index: 9,
            nickname: "name3",
            score: 333,
            userId: "33333"
          }
        ]
      })
    }
  }
  /**
   * 展示排行榜奖品弹窗
   */
  async showRankPrizeModal() {
    let { rankPrizeInfo, modalState } = this.state;
    let rankPrizeData = await API.rankPop();
    console.log('rankPrizeData=====', rankPrizeData);
    let { data, success } = rankPrizeData;
    if (success && data.show) {
      this.setState({
        rankPrizeInfo: data
      })
    } else {
      this.setState({
        rankPrizeInfo: {
          show: true, //boolean	
          rank: 25,//number	
          prizeName: "中的奖品",//string	
          prizePic: "http://yun.duiba.com.cn/spark/assets/273d0395e7c858d2fdae770fd3716401e431146d.png",//string	
          prizeUrl: "www.baidu.com"//string
        },
        // modalState: MODAL_MAP.rankPrize
      })

    }
  }
  /**
   * 获取邀请记录弹窗
    userName	string	
    userId	number	
    avatar	string	
    bonus	number	
    inviteTime
   */
  async onShowInviteRecord() {
    let { inviteRecordList } = this.state;
    let inviteData = await API.inviteList();
    console.log('inviteData==', inviteData);
    this.modalControl('inviteRecord');
    let arr = [
      { userName: "打大声道", userId: "", avatar: "", bonus: "奖励1", inviteTime: "1" },
      { userName: "打算", userId: "", avatar: "", bonus: "奖励2", inviteTime: "2" },
      { userName: "sad", userId: "", avatar: "", bonus: "奖励3", inviteTime: "3" },
      { userName: "搭嘎授权驱蚊器无", userId: "", avatar: "", bonus: "奖励4", inviteTime: "4" },
      { userName: "大沙发沙发沙发发dasdasdasd asdasd声方法是否", userId: "", avatar: "", bonus: "奖励5", inviteTime: "5" },
      { userName: "ad", userId: "", avatar: "", bonus: "奖励6", inviteTime: "6" },
      { userName: "发", userId: "", avatar: "", bonus: "奖励7", inviteTime: "7" },
      { userName: "的大事发生", userId: "", avatar: "", bonus: "奖励8", inviteTime: "8" },
      { userName: "阿萨德", userId: "", avatar: "", bonus: "奖励9", inviteTime: "9" },
    ];
    this.setState({
      inviteRecordList: arr
    })
  }



  async getExchangeGoods() {
    let { exchangeGoodsList } = this.state;
    let exchangeData = await API.exchangeList();
    console.log('exchangeData===', exchangeData);
    let goodsDataList = [
      { prizeName: "商品1", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      { prizeName: "商品2", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      { prizeName: "商品3", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品4", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品5", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品6", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品7", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
    ];

    this.setState({
      exchangeGoodsList: goodsDataList
    })

  }
  /**
   * 选择兑换商品
   * @param {*} goodsInfo 
   */
  showExchangeGoodsModal(goodsInfo) {
    let { chooseGoodsInfo } = this.state;
    this.setState({
      chooseGoodsInfo: goodsInfo,
      modalState: MODAL_MAP['exchangeGoods']
    })


  }



  async getExchangeGoods() {
    let { exchangeGoodsList } = this.state;
    let exchangeData = await API.exchangeList();
    console.log('exchangeData===', exchangeData);
    let goodsDataList = [
      { prizeName: "商品1", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      { prizeName: "商品2", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      { prizeName: "商品3", prizePrice: 100, prizePic: "http:////yun.duiba.com.cn/spark/assets/25bbdee60bf3b0bf8f3405baf4ad18433f7ce82f.png", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品4", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品5", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品6", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
      // { prizeName: "商品7", prizePrice: 100, prizePic: "奖品图片", ruleId: "ru_1", needCount: 10 },
    ];

    this.setState({
      exchangeGoodsList: goodsDataList
    })

  }
  /**
   * 选择兑换商品
   * @param {*} goodsInfo 
   */
  showExchangeGoodsModal(goodsInfo) {
    let { chooseGoodsInfo } = this.state;
    this.setState({
      chooseGoodsInfo: goodsInfo,
      modalState: MODAL_MAP['exchangeGoods']
    })
  }

  render() {
    let { nickname, avatar, energy, yesterdayStepCount, myscore, myindex, taskList, rule, modalState, rankList, inviteList, rankPrizeInfo, inviteRecordList, chooseGoodsInfo, goodlist, shareMask } = this.state
    return (
      <div className="mainscene">
        <img className="mainbg" src={this.state.resList['239f9738-1a44-4fed-93e2-cbb52b2c07dd'].url} />
        <img className="rulebtn" onClick={() => { console.log('点击获取排行榜信息'); this.showRule() }} src={this.state.resList['bb5d7e1f-026c-460d-a7a7-99bb089fc022'].url} />
        <img className="recordbtn" src={this.state.resList['bd96b86c-782c-4375-b899-5b2d421ddd06'].url} />
        <div className="usermes">
          <img className="usermesbg" src={this.state.resList['9ce50cdd-59ed-4d60-a7b5-4509e2dd030f'].url} />
          <img className="usermesiconbg" src={this.state.resList['c56a8a4b-a0ce-48ff-acc2-e4b3f98d86fc'].url} />
          <img className="usermesicon" src={avatar} />
          <label className="usermesname">{nickname}</label>
          <label className="usermesenerge">我的能量:{energy}</label>
        </div>
        <div className="laststep">
          <label className="laststepnum">{yesterdayStepCount}</label>
          <img className="laststepbar" src={this.state.resList['2f57b289-a595-45d0-95f6-1ca310c0b845'].url} />
          <img className="laststeplab" src={this.state.resList['2a115def-3711-469b-b785-d61a03034a28'].url} />
          <img className="laststepbtn" src={this.state.resList['0f7e7944-459d-45c6-84c5-a4ffe94be265'].url} />
        </div>
        <div className="step">
          <img className="stepbg" src={this.state.resList['015e1dc4-b72e-42a7-991c-44ea23a973ad'].url} />
          <img className="steplibg" src={this.state.resList['bd563f58-8246-4ff5-a80c-a2d3f7a38caf'].url} />
          <img className="stepnum" src={this.state.resList['60f68768-5464-4a8f-a8bc-766b93e36dbf'].url} />
          <label className="stepnumlab">{myscore}</label>
          <img className="steprank" src={this.state.resList['e2a5dcd1-5b3b-468c-94f5-98d1ad511463'].url} />
          {/* 调用接口获取排行榜信息 */}
          <label className="stepranknum" onClick={() => { console.log('点击获取排行榜信息'); this.showRank() }}>{`${myindex}  >`}</label>
        </div>
        <div className="people">
          <img className="peoplebg" src={this.state.resList['f28dfeb9-cc40-4410-af01-63686d775867'].url} />
          <label className="peoplelab">坚持运动是了 不起的习惯哦</label>
          <img className="peopleimg" src={this.state.resList['6d181837-2468-4ecd-a496-afddc37408a3'].url} />
        </div>
        <div className="poptask">
          <img className="poptaskimg3" src={this.state.resList['fce08be8-3834-4bc6-bce1-2580e82feb55'].url} />
          <label className="poptasklab3">10</label>
          <img className="poptaskimg5" src={this.state.resList['911b338d-5edc-4330-b023-3c5d06ed6297'].url} />
          <label className="poptasklab5">100</label>
          <img className="poptaskimg4" src={this.state.resList['57c4d641-4b51-4d55-94fe-21f3c1c1e478'].url} />
          <label className="poptasklab4">50</label>
          <img className="poptaskimg2" src={this.state.resList['4381d12a-1a9e-4e49-84e4-8d6cf9134f5b'].url} />
          <label className="poptasklab2">50</label>
          <img className="poptaskimg1" src={this.state.resList['33aadbe5-7e84-4c40-9e0e-6a8ac7c340bf'].url} />
          <label className="poptasklab1">10</label>
        </div>
        <div className="task">
          <img className="taskbg" src={this.state.resList['5ab12e23-4d42-4e01-bdea-27c15ff7bc47'].url} />
          <div className="tasks">
            <div className="task3">
              <img className="task3icon float" src={taskList[0].icon} />
              {/* <div className="task3icon float"></div> */}
              <label className="task3lab float">{taskList[0].taskTotalCount > 1 ? `${taskList[0].taskName}(${taskList[0].taskFinishCount}/${taskList[0].taskTotalCount})` : taskList[0].taskName}</label>
              <img className="taskprize3img float" src={this.state.resList['bff0ebf6-92f0-4331-be4e-be162d2f7da6'].url} />
              <label className="taskprize3num float">+{taskList[0].taskBonus}</label>
              {!taskList[0].finish ?
                <div>
                  {taskList[0].url ? <img className="task3gobtn " src={this.state.resList['66341566-3f57-487b-ba38-6bacea0efad9'].url} onClick={this.goFinishTask.bind(this, 0, taskList[0].taskId)} />
                    : <img className="task3gobtn " src={this.state.resList['89ae47c5-e6b9-44d6-8be5-fd425c33b569'].url} onClick={this.goFinishTask.bind(this, 0, taskList[0].taskId)} />}
                </div>
                : <img className="task3finbtn " src={this.state.resList['5eb5dbe3-3ad7-4f0c-91b2-ba790167c98b'].url} />
              }
            </div>
            <div className="task3">
              <img className="task3icon float" src={taskList[1].icon} />
              {/* <div className="task3icon float"></div> */}
              <label className="task3lab float">{taskList[1].taskTotalCount > 1 ? `${taskList[1].taskName}(${taskList[1].taskFinishCount}/${taskList[1].taskTotalCount})` : taskList[1].taskName}</label>
              <img className="taskprize3img float" src={this.state.resList['bff0ebf6-92f0-4331-be4e-be162d2f7da6'].url} />
              <label className="taskprize3num float">+{taskList[1].taskBonus}</label>
              {!taskList[1].finish ?
                <div>
                  {taskList[1].url ? <img className="task3gobtn " src={this.state.resList['66341566-3f57-487b-ba38-6bacea0efad9'].url} onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)} />
                    : <img className="task3gobtn " src={this.state.resList['89ae47c5-e6b9-44d6-8be5-fd425c33b569'].url} onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)} />}
                </div>
                : <img className="task3finbtn " src={this.state.resList['5eb5dbe3-3ad7-4f0c-91b2-ba790167c98b'].url} />
              }
            </div>
            <div className="task3">
              <img className="task3icon float" src={taskList[2].icon} />
              {/* <div className="task3icon float"></div> */}
              <label className="task3lab float">{taskList[2].taskTotalCount > 1 ? `${taskList[2].taskName}(${taskList[2].taskFinishCount}/${taskList[2].taskTotalCount})` : taskList[2].taskName}</label>
              <img className="taskprize3img float" src={this.state.resList['bff0ebf6-92f0-4331-be4e-be162d2f7da6'].url} />
              <label className="taskprize3num float">+{taskList[2].taskBonus}</label>
              {!taskList[2].finish ?
                <div>
                  {taskList[2].url ? <img className="task3gobtn " src={this.state.resList['66341566-3f57-487b-ba38-6bacea0efad9'].url} onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)} />
                    : <img className="task3gobtn " src={this.state.resList['89ae47c5-e6b9-44d6-8be5-fd425c33b569'].url} onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)} />}
                </div>
                : <img className="task3finbtn " src={this.state.resList['5eb5dbe3-3ad7-4f0c-91b2-ba790167c98b'].url} />
              }
            </div>
          </div>
          <img className="tasktitle" src={this.state.resList['aca71fa0-8903-4e2e-8dec-d09c01474301'].url} />
        </div>
        <div className="invite">
          <img className="invitebg" src={this.state.resList['c8f3c748-5f59-4149-ba87-92476a69d06c'].url} />
          <div className="invitepeo">
            {
              inviteList && inviteList.map((item, index) => {
                return (
                  <div key={index}>
                    {index < 10 ?
                      <div className="invitepeoitem">
                        <img className="invitepeoitembg" src={this.state.resList['5df866e6-9da7-4602-a40c-f741185befd7'].url} />
                        <img className="invitepeoitemicon" src={this.state.resList['5db27635-1675-4662-a3a8-47fc93d571b3'].url} />
                        <img className="invitepeoitemadd" src={this.state.resList['8ab64c8d-d154-4e50-ac3f-6b5eacbbfc3d'].url} />
                      </div> : null
                    }
                  </div>
                )
              })
            }
            {
              this.noinviteList && this.noinviteList.map((item, index) => {
                return (
                  <div className="invitepeoitem" key={index}>
                    <img className="invitepeoitembg" src={this.state.resList['5df866e6-9da7-4602-a40c-f741185befd7'].url} />
                    <img className="invitepeoitemicon" onClick={this.inviteShare.bind(this)} />
                    <img className="invitepeoitemadd" src={this.state.resList['8ab64c8d-d154-4e50-ac3f-6b5eacbbfc3d'].url} onClick={this.inviteShare.bind(this)} />
                  </div>
                )
              })
            }

          </div>
          <img className="invitebtn" src={this.state.resList['987a106c-113c-4bb5-ab98-b903fbc3064f'].url} onClick={this.inviteShare.bind(this)} />
          <img className="invitelab" src={this.state.resList['507f09ac-cfef-4c08-b371-12b95a9cbbd4'].url} />
          <img className="inviterecord" src={this.state.resList['4d39de00-ebcc-4d85-826f-a4600c3de49b'].url} />
          <img className="invitetitle" src={this.state.resList['ef0eec26-ee89-413e-8d6d-dd1a9c995397'].url} />
          <div className="inviteimg">
            <img className="inviteimgbar" src={this.state.resList['aa11361b-d5d9-4890-a635-e33228a2f868'].url} />
            <img className="inviteimg1" src={this.state.resList['2c9b86cf-4533-4a1a-8a4d-1bf643bb88eb'].url} />
          </div>
        </div>
        <div className="exchange">
          <img className="exchangebg" src={this.state.resList['c862929e-ba89-4078-b98a-331322f8ee3e'].url} />{goodlist.length}
          <div className="exchangelist">
            {
              goodlist && goodlist.map((item, index) => {
                return (
                  <div className="exchangelistitem" key={index}>
                    <img
                      className="exchangelistitemimg"
                      src={item.prizePic}
                    />
                    <img
                      className="exchangelistitembtn"
                      src={resList['e2decafd-8da8-422d-afab-37410d3749e0'].url}
                      onClick={() => { this.showExchangeGoodsModal(item); }}
                    />
                    <label className="exchangelistitemname">{item.prizeName}</label>
                    <label className="exchangelistitemprize">{item.needCount}能量</label>
                    <label className="exchangelistitemold">原价:{item.prizePrice}元</label>
                  </div>
                )

              })
            }

          </div>
        </div>
        {
          shareMask ?
            <div className="shareMask" onClick={this.closeShare.bind(this)}>
              <div className="shareImg">
              </div>
            </div> : null
        }
        {/* <div className="shareMask" onClick={this.closeShare.bind(this)}>
            <div className="shareImg">
            </div>
        </div> */}
        {/* 规则弹窗 */}
        { MODAL_MAP["rule"] === modalState && <RuleModal rule={rule} onClose={() => { this.modalControl() }}></RuleModal>}
        { MODAL_MAP["rankInfo"] === modalState && <RankModal myRankData={this.dataStore.myrank} rankList={rankList} onClose={() => { this.modalControl() }}></RankModal>}
        {/* RankPrizeModal ExchangeModal InviteRcordModal  */}
        { MODAL_MAP["rankPrize"] === modalState && <RankPrizeModal rankPrizeInfo={rankPrizeInfo} onClose={() => { this.modalControl() }} />}
        { MODAL_MAP["exchangeGoods"] === modalState && <ExchangeModal goodsInfo={chooseGoodsInfo} onClose={() => { this.modalControl() }} />}
        { MODAL_MAP["inviteRecord"] === modalState && <InviteRcordModal inviteRecordList={inviteRecordList} onClose={() => { this.modalControl() }} />}

      </div >
    );
  }
}
export default Pagemainscene;
