
import { Data } from "../../Data";
import { IPrizeData } from "./IPrizeData";
/**
 *Created by cuiliqiang on 2018/3/30
 * 查询插件剩余抽奖次数
 */
export class GetPrizeInfoData extends Data {
    /**
     * 需要消耗的积分
     */
    public creditsPrice: number;

    /**
     * 周期每天/永久
     */
    public limitScope: number;

    /**
     * 剩余次数
     */
    public limitCount: number;

    /**
     * 规则
     */
    public ruleDescription: string;

    /**
     * 时间
     */
    public rateDescription: string;

    /**
     * 奖品列表
     */
    public prizeList: IPrizeData[];

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.creditsPrice = data.creditsPrice;
        this.limitScope = data.limitScope;
        this.limitCount = data.limitCount;
        this.ruleDescription = data.ruleDescription;
        this.rateDescription = data.rateDescription;
        this.prizeList = data.prize;
    }
}