import { GameModel } from '../common/GameModel';
import { DataManager } from '../../manager/DataManager';
import { NetManager } from '../../manager/NetManager';
export class GameStartModel extends GameModel {
    /**
     * 剩余次数
     * 为了按钮字体的美观，不展示开始游戏之外的文案，非常规状态由业务文案代替展示。
     */
    public get countTxt(): string {
        let txt: string;
        if (DataManager.ins.getInfoData.status.code != 0) {
            txt = DataManager.ins.getInfoData.status.btnText;
        } else {
            txt = DataManager.ins.getInfoData.status.text;
        }
        return txt;
    }

    /**
     * 开始游戏按钮状态
     */
    public get startBtnEnable(): boolean {
        let enable: boolean;
        if (DataManager.ins.getInfoData.status.btnDisable || DataManager.ins.getInfoData.status.code == 6) {
            enable = false;
        } else {
            enable = true;
        }
        return enable;
    }
}
