/**
 *Created by cuiliqiang on 2018/3/9
 * 猜扑克数据
 */
import { Data } from "../../Data";

export class GuessPokerData extends Data {
    /**
     * 是否猜中
     */
    public isWin: boolean;

    /**
     * 发出的卡牌
     */
    public poker: number;

    /**
     * 当前成长值
     */
    public score: number;

    /**
     * 当前第几轮
     */
    public times: number;

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        if (!data.data) {
            return;
        }
        this.isWin = data.data.win;
        this.poker = data.data.poker;
        this.score = data.data.score;
        this.times = data.data.times;
    }
}