import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class WarningPanel extends Panel {

    public get skinKey() { return 'Warning' }
    public get groupName() { return 'warning_panel' }

    public panelGroup: eui.Group;
    public okBtn: eui.Button;
    public closeBtn: eui.Button;
    public titleImg:eui.Image;
    public iconImg:eui.Image;
    public txtLb:eui.Label;

    private mdata:any;

    start(data) {
        this.percentHeight = 100;

        this.mdata = data;
    }

    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    private onLoad():void{
    }

    initEvents() {
        super.initEvents();

        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_okBtn, this);

    }

    removeEvents() {
        super.removeEvents();
        if(this.okBtn){
            this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_okBtn, this);
        }
    }

    private onTap_okBtn():void{
        this.onTouchTap();

    }


    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
    }

} 